% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R
\name{ScaleData}
\alias{ScaleData}
\alias{ScaleData.default}
\alias{ScaleData.Assay}
\alias{ScaleData.Seurat}
\title{Scale and center the data.}
\usage{
ScaleData(object, ...)

\method{ScaleData}{default}(
  object,
  features = NULL,
  vars.to.regress = NULL,
  latent.data = NULL,
  split.by = NULL,
  model.use = "linear",
  use.umi = FALSE,
  do.scale = TRUE,
  do.center = TRUE,
  scale.max = 10,
  block.size = 1000,
  min.cells.to.block = 3000,
  verbose = TRUE,
  ...
)

\method{ScaleData}{Assay}(
  object,
  features = NULL,
  vars.to.regress = NULL,
  latent.data = NULL,
  split.by = NULL,
  model.use = "linear",
  use.umi = FALSE,
  do.scale = TRUE,
  do.center = TRUE,
  scale.max = 10,
  block.size = 1000,
  min.cells.to.block = 3000,
  verbose = TRUE,
  ...
)

\method{ScaleData}{Seurat}(
  object,
  features = NULL,
  assay = NULL,
  vars.to.regress = NULL,
  split.by = NULL,
  model.use = "linear",
  use.umi = FALSE,
  do.scale = TRUE,
  do.center = TRUE,
  scale.max = 10,
  block.size = 1000,
  min.cells.to.block = 3000,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{features}{Vector of features names to scale/center. Default is variable features.}

\item{vars.to.regress}{Variables to regress out (previously latent.vars in
RegressOut). For example, nUMI, or percent.mito.}

\item{latent.data}{Extra data to regress out, should be cells x latent data}

\item{split.by}{Name of variable in object metadata or a vector or factor defining
grouping of cells. See argument \code{f} in \code{\link[base]{split}} for more details}

\item{model.use}{Use a linear model or generalized linear model
(poisson, negative binomial) for the regression. Options are 'linear'
(default), 'poisson', and 'negbinom'}

\item{use.umi}{Regress on UMI count data. Default is FALSE for linear
modeling, but automatically set to TRUE if model.use is 'negbinom' or 'poisson'}

\item{do.scale}{Whether to scale the data.}

\item{do.center}{Whether to center the data.}

\item{scale.max}{Max value to return for scaled data. The default is 10.
Setting this can help reduce the effects of features that are only expressed in
a very small number of cells. If regressing out latent variables and using a
non-linear model, the default is 50.}

\item{block.size}{Default size for number of features to scale at in a single
computation. Increasing block.size may speed up calculations but at an
additional memory cost.}

\item{min.cells.to.block}{If object contains fewer than this number of cells,
don't block for scaling calculations.}

\item{verbose}{Displays a progress bar for scaling procedure}

\item{assay}{Name of Assay to scale}
}
\description{
Scales and centers features in the dataset. If variables are provided in vars.to.regress,
they are individually regressed against each feature, and the resulting residuals are
then scaled and centered.
}
\details{
ScaleData now incorporates the functionality of the function formerly known
as RegressOut (which regressed out given the effects of provided variables
and then scaled the residuals). To make use of the regression functionality,
simply pass the variables you want to remove to the vars.to.regress parameter.

Setting center to TRUE will center the expression for each feature by subtracting
the average expression for that feature. Setting scale to TRUE will scale the
expression level for each feature by dividing the centered feature expression
levels by their standard deviations if center is TRUE and by their root mean
square otherwise.
}
