% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols.R
\name{reg_ss.fit}
\alias{reg_ss.fit}
\title{Inference in a shift-share regression}
\usage{
reg_ss.fit(y, X, W, Z, w = NULL, method = c("akm", "akm0"),
  beta0 = 0, alpha = 0.05, region_cvar = NULL, sector_cvar = NULL)
}
\arguments{
\item{y}{Outcome variable, vector of length \code{N}}

\item{X}{Shift-share vector with length \code{N} of sectoral shocks,
aggregated to regional level using the share matrix \code{W}.}

\item{W}{A matrix of sector shares, so that \code{W[i, s]} corresponds to
share of sector \code{s} in region \code{i}}

\item{Z}{Matrix of regional controls, matrix with \code{N} rows corresponding
to regions.}

\item{w}{vector of weights (length \code{N}) to be used in the fitting
process. If not \code{NULL}, weighted least squares is used with weights
\code{w}, i.e., \code{sum(w * residuals^2)} is minimized.}

\item{method}{Vector specifying which inference methods to use. The vector
    elements have to be one or more of the following strings:

\describe{

\item{\code{"homosk"}}{Assume i.i.d. homoskedastic errors}

\item{\code{"ehw"}}{Eicker-Huber-White standard errors}

\item{\code{"region_cluster"}}{Standard errors clustered at regional level}

\item{\code{"akm"}}{Adão-Kolesár-Morales}

\item{\code{"akm0"}}{Adão-Kolesár-Morales with null imposed. Note the
reported standard error for this method corresponds to the normalized
standard error, given by the length of the confidence interval divided by
\eqn{2z_{1-\alpha/2}}{2z_{1-alpha/2}}}

\item{\code{"all"}}{All of the methods above}}}

\item{beta0}{null that is tested (only affects reported p-values)}

\item{alpha}{Determines confidence level of reported confidence intervals,
which will have coverage \code{1-alpha}.}

\item{region_cvar}{A vector with length \code{N} of cluster variables, for
method \code{"cluster_region"}. If the vector \code{1:N} is used,
clustering is effectively equivalent to \code{ehw}}

\item{sector_cvar}{A vector with length \code{S} of cluster variables, if
sectors are to be clustered, for methods \code{"akm"} and \code{"akm0"}.
If the vector \code{1:S} is used, this is equivalent to not clustering.}
}
\value{
Returns an object of class \code{"SSResults"} containing the
    estimation and inference results. The \code{print} function can be used
    to print a summary of the results. The object is a list with at least the
    following components: \describe{

\item{beta}{Point estimate of the effect of interest \eqn{\beta}{beta}}

\item{se, p}{A vector of standard errors and a vector of p-values of the null
\eqn{H_{0}\colon \beta = 0}{H_0 : beta = 0} for the inference methods in
\code{method}. For the method \code{"akm0"}, the standard error corresponds
to the effective standard error (length of the confidence interval divided by
\code{2*stats::qnorm(1-alpha/2)})}

\item{ci.l, ci.r}{Upper and lower enpoints of the confidence interval for the
effect of interest \eqn{\beta}{beta}, for each of the methods in \code{method}}

}
}
\description{
Basic computing engine to calculate confidence intervals and p-values in
shift-share designs using different inference methods, as specified by
\code{method}.
}
