% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_BFI2.R
\docType{data}
\encoding{UTF-8}
\name{BFI2}
\alias{BFI2}
\title{BFI2 Dataset}
\format{
\code{BFI2} is a \code{data.frame} consisting of
1,733
observations on 64 variables.
\describe{
\item{i1--i60}{The BFI items, scored on Likert scale where
\code{1} = Disagree strongly,
\code{2} = Disagree a little,
\code{3} = Neutral; no opinion,
\code{4} = Agree a little, and
\code{5} = Agree strongly.
Some items were recoded so that all items are scored in the same direction, see Details.}
\item{Gender}{Gender membership, \code{0} = females, \code{1} = males.}
\item{Age}{Age in years.}
\item{Educ}{Education,
\code{1} = Basic school,
\code{2} = Secondary technical school,
\code{3} = Secondary general school,
\code{4} = Other secondary school,
\code{5} = Tertiary professional school,
\code{6} = Bachelor degree,
\code{7} = Masters degree,
\code{8} = PhD}
}
}
\usage{
data(BFI2)
}
\description{
\code{BFI2} dataset (Hřebíčková et al., 2020) consists of responses of
1,733
respondents
(1,003
females,
730
males) to Big Five Inventory 2 (BFI-2). It contains 60 ordinal items, vector
of age, education, and vector of gender membership.
}
\details{
The items prefixed with \code{i} are item scores. Items are indicators of 5 latent
personality factors/dimensions/domains, which are further broken down into
so-called facets. The 5 personality domains are: N = Negative Emotionality, E
= Extraversion, O = Open-Mindedness, C = Consciousness and A = Agreeability.
These are further broken down into so-called facets, as shown in the
following table:\tabular{lll}{
   \strong{Domain} \tab \strong{Facet} \tab \strong{Item numbers} \cr
   E \tab Sociability (scb) \tab 1, 16, 31, 46 \cr
   E \tab Assertiveness (asr) \tab 6, 21, 36, 51 \cr
   E \tab Energy Level (enl) \tab 11, 26, 41, 56 \cr
   A \tab Compassion (cmp) \tab 2, 17, 32, 47 \cr
   A \tab Respectfulness (rsp) \tab 7, 22, 37, 52 \cr
   A \tab Trust (trs) \tab 12, 27, 42, 57 \cr
   C \tab Organization (org) \tab 3, 18, 33, 48 \cr
   C \tab Productiveness (prd) \tab 8, 23, 38, 53 \cr
   C \tab Responsibility (rsp) \tab 13, 28, 43, 58 \cr
   N \tab Anxiety (anx) \tab 4, 19, 34, 49 \cr
   N \tab Depression (dep) \tab 9, 24, 39, 54 \cr
   N \tab Emotional Volatility (emt) \tab 14, 29, 44, 59 \cr
   O \tab Intellectual Curiosity (int) \tab 10, 25, 40, 55 \cr
   O \tab Aesthetic Sensitivity (aes) \tab 5, 20, 35, 50 \cr
   O \tab Creative Imagination (crt) \tab 15, 30, 45, 60 \cr
}


In the original instrument, some items are inversely oriented, i.e., the
higher score means the lower latent trait. This was the case of items number
3, 4, 5, 8, 9, 11, 12, 16, 17, 22, 23, 24, 25, 26, 28, 29, 30, 31, 36, 37,
42, 44, 45, 47, 48, 49, 50, 51, 55, and 58. These \strong{items have been recoded}
for you, i.e., displayed is value of \verb{6 - original score}.

In the sample code, alternative item names are provided. These item names
can be used to decode the item domain, facet, item number, and
whether it was recoded or not. For example, \code{iCorg03r} stands for recoded 3rd
item (out of 60) from Consciousness domain and Organization facet.
}
\note{
Thanks to Martina Hřebíčková for sharing this dataset.
}
\examples{
data(BFI2)
colnames(BFI2)[1:60] <- c("iEscb01", "iAcmp02", "iCorg03r", "iNanx04r", "iOaes05r", "iEasr06",
"iArsp07", "iCprd08r", "iNdep09r", "iOint10", "iEenl11r", "iAtrs12r", "iCrsp13", "iNemt14",
"iOcrt15", "iEscb16r", "iAcmp17r", "iCorg18", "iNanx19", "iOaes20", "iEasr21", "iArsp22r",
"iCprd23r", "iNdep24r", "iOint25r", "iEenl26r", "iAtrs27", "iCrsp28r", "iNemt29r",
"iOcrt30r", "iEscb31r", "iAcmp32", "iCorg33", "iNanx34", "iOaes35", "iEasr36r", "iArsp37r",
"iCprd38", "iNdep39", "iOint40", "iEenl41", "iAtrs42r", "iCrsp43", "iNemt44r", "iOcrt45r",
"iEscb46", "iAcmp47r", "iCorg48r", "iNanx49r", "iOaes50r", "iEasr51r", "iArsp52", "iCprd53",
"iNdep54", "iOint55r", "iEenl56", "iAtrs57", "iCrsp58r", "iNemt59", "iOcrt60")

}
\references{
Hřebíčková, M., Jelínek, M., Květon,P., Benkovič, A., Botek, M.,
Sudzina, F. Soto, Ch., John, O. (2020).  Big Five Inventory 2 (BFI-2):
Hierarchický model s 15 subškálami [Big Five Inventory 2 (BFI-2):
Hierarchical model with 15 subscales, in Czech]. \emph{Československá
psychologie, 64,} 437--460.

Soto, C. J., & John, O. P. (2017). The next Big Five Inventory (BFI-2):
Developing and assessing a hierarchical model with 15 facets to enhance
bandwidth, fidelity, and predictive power. \emph{Journal of Personality and
Social Psychology, 113,} 117--143.
}
\keyword{datasets}
