% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R
\name{FindTopFeatures}
\alias{FindTopFeatures}
\alias{FindTopFeatures.default}
\alias{FindTopFeatures.Assay}
\alias{FindTopFeatures.Seurat}
\title{Find most frequently observed features}
\usage{
FindTopFeatures(object, ...)

\method{FindTopFeatures}{default}(object, assay = NULL, min.cutoff = "q5", verbose = TRUE, ...)

\method{FindTopFeatures}{Assay}(object, assay = NULL, min.cutoff = "q5", verbose = TRUE, ...)

\method{FindTopFeatures}{Seurat}(object, assay = NULL, min.cutoff = "q5", verbose = TRUE, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Arguments passed to other methods}

\item{assay}{Name of assay to use}

\item{min.cutoff}{Cutoff for feature to be included in the VariableFeatures
for the object. This can be a percentile specified as 'q' followed by the
minimum percentile, for example 'q5' to set the top 95\% most common features
as the VariableFeatures for the object. Alternatively, this can be an integer
specifying the minumum number of cells containing the feature for the feature
to be included in the set of VariableFeatures. For example, setting to 10
will include features in >10 cells in the set of VariableFeatures. If NULL,
include all features in VariableFeatures.}

\item{verbose}{Display messages}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object
}
\description{
Find top binary features for a given assay based on total number of cells
containing feature. Can specify a minumum cell count, or a lower percentile
bound.
}
\examples{
FindTopFeatures(object = atac_small[['peaks']][])
FindTopFeatures(object = atac_small[['peaks']])
FindTopFeatures(atac_small)
}
\concept{preprocessing}
