% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mparseRcpp.R
\name{mparseRcpp}
\alias{mparseRcpp}
\title{Parse custom model using \code{SimInf} style markup}
\usage{
mparseRcpp(transitions = NULL, compartments = NULL, pars = NULL,
  obsProcess = NULL, addVars = NULL, stopCrit = NULL,
  tspan = FALSE, incidence = FALSE, afterTstar = NULL, PF = FALSE,
  runFromR = TRUE)
}
\arguments{
\item{transitions}{character vector containing transitions on the form \code{"X ->
... -> Y"}. The left (right) side is the initial (final)
state and the propensity is written in between the
\code{->}-signs. The special symbol \code{@} is reserved for the empty
set. For example, \code{transitions = c("S -> k1*S*I -> I", "I ->
k2*I -> R")} expresses a SIR model.}

\item{compartments}{contains the names of the involved compartments, for
example, \code{compartments = c("S", "I", "R")}.}

\item{pars}{a \code{character} vector containing the names of the parameters.}

\item{obsProcess}{\code{data.frame} determining the observation process. Columns must be in the order:
\code{dataNames}, \code{dist}, \code{p1}, \code{p2}. \code{dataNames} is a \code{character}
denoting the name of the variable that will be output from the observation process; \code{dist} 
is a \code{character} specifying the distribution of the observation process (must be one of 
\code{"unif"}, \code{"pois"}, \code{"norm"} or \code{"binom"} at the current time); \code{p1} is the first parameter 
(the lower bound in the case of \code{"unif"}, the rate in the case of \code{"pois"}, the mean in the case of 
\code{"norm"} or the \code{size} in the case of \code{"binom"}); and finally \code{p2} is the second parameter 
(the upper bound in the case of \code{"unif"}, \code{NA} in the case of \code{"pois"}, the standard deviation in 
the case of \code{"norm"}, and \code{prob} in the case of \code{"binom"}).}

\item{addVars}{a \code{character} vector where the names specify the additional variables to be added to the 
function call. These can be used to specify variables that can be used for 
e.g. additional stopping criteria.}

\item{stopCrit}{A \code{character} vector including additional stopping criteria for rejecting
simulations early. These will be inserted within \code{if(CRIT){out[0] = 0; return out;}} statements
within the underlying Rcpp code, which a return value of 0 corresponds to rejecting
the simulation. Variables in \code{CRIT} must match either those in \code{compartments}
and/or \code{addVars}.}

\item{tspan}{A \code{logical} determining whether to return time series counts or not.}

\item{incidence}{A \code{logical} specifying whether to return incidence curves in addition to counts.}

\item{afterTstar}{A \code{character} containing code to insert after each new event time is
generated.}

\item{PF}{A \code{logical} determining whether to compile the code for use in a particle filter.}

\item{runFromR}{\code{logical} determining whether code is to be compiled to run directly in R,
or whether to be compiled as an \code{XPtr} object for use in Rcpp.}
}
\value{
An object of class \code{SimBIID_model}, which is essentially a \code{list} 
        containing elements:
        \itemize{
            \item{code:}{ parsed code to compile;}
            \item{transitions:}{ copy of \code{transitions} argument;}
            \item{compartments:}{ copy of \code{compartments} argument;}
            \item{pars:}{ copy of \code{pars} argument;}
            \item{obsProcess:}{ copy of \code{obsProcess} argument;}
            \item{stopCrit:}{ copy of \code{stopCrit} argument;}
            \item{addVars:}{ copy of \code{addVars} argument;}
            \item{tspan:}{ copy of \code{tspan} argument;}
            \item{incidence:}{ copy of \code{incidence} argument;}
            \item{afterTstar:}{ copy of \code{afterTstar} argument;}
            \item{PF:}{ copy of \code{PF} argument;}
            \item{runFromR:}{ copy of \code{runFromR} argument.}
        }
        This can be compiled into an \code{XPtr} or \code{function} object
        using \code{compileRcpp()}.
}
\description{
Parse custom model using \code{SimInf} style markup.
    Does not have full functionality of \code{mparse}. Currently only supports
    simulations on a single node.
}
\details{
Uses a \code{SimInf} style markup to create compartmental state-space
    written using \code{Rcpp}. A helper \code{run} function exists to compile 
    and run the model. Another helper function, \code{compileRcpp},
    can compile the model to produce a function that can be run directly from R, 
    or compiled into an external pointer (using the \code{RcppXPtrUtils} package).
}
\examples{
\donttest{

## set up SIR simulation model
transitions <- c(
    "S -> beta * S * I -> I", 
    "I -> gamma * I -> R"
)
compartments <- c("S", "I", "R")
pars <- c("beta", "gamma")
model <- mparseRcpp(
    transitions = transitions, 
    compartments = compartments,
    pars = pars
)

## compile and run model
sims <- run(
    model = model,
    pars = c(beta = 0.001, gamma = 0.1),
    tstart = 0,
    tstop = 100,
    u = c(S = 119, I = 1, R = 0)
)
sims
}

}
\seealso{
\code{\link{run}}, \code{\link{compileRcpp}}, \code{\link{print.SimBIID_model}}
}
