% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_builder.R
\name{mparse}
\alias{mparse}
\title{Model parser}
\usage{
mparse(transitions = NULL, compartments = NULL, ...)
}
\arguments{
\item{transitions}{character vector containing transitions on the
form \code{"X -> ... -> Y"}. The left (right) side is the
initial (final) state and the propensity is written in between
the \code{->}-signs. The special symbol \code{@} is reserved
for the empty set. For example, \code{transitions =
c("S -> k1*S*I -> I", "I -> k2*I -> R")} expresses a SIR
model.}

\item{compartments}{contains the names of the involved
compartments, for example, \code{compartments = c("S", "I",
"R")}.}

\item{...}{rate-constants for the model.}
}
\value{
\linkS4class{SimInf_mparse}
}
\description{
Model parser
}
\examples{
\dontrun{
## Use the model parser to create a 'SimInf_mparse' object
m <- mparse(c("S -> k1*S*I/(S+I+R) -> I", "I -> k2*I -> R"),
            c("S", "I", "R"), k1 = 0.16, k2 = 0.077)

## Initialize a 'SimInf_model' from the 'SimInf_mparse' object
u0 <- data.frame(S = 100, I = 1, R = 0)
model <- init(m, u0 = u0, tspan = 1:100)

## Run and plot the result
plot(run(model))
}
}
