% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SEIR.R, R/SIR.R
\docType{methods}
\name{recovered}
\alias{recovered}
\alias{recovered,SEIR-method}
\alias{recovered,SIR-method}
\title{Recovered}
\usage{
recovered(model, ...)

\S4method{recovered}{SEIR}(model, i = NULL, by = 1, ...)

\S4method{recovered}{SIR}(model, i = NULL, by = 1, ...)
}
\arguments{
\item{model}{The \code{model} to extract the recovered from}

\item{...}{Additional arguments affecting the measure}

\item{i}{Indices specifying the nodes to include when extracting
the number of recovered. Default is NULL, which includes all nodes.}

\item{by}{The number to increment the sequence of time points
starting from 1. Default is 1, which gives the number of
recovered at every time point.}
}
\description{
Extracts the number of recovered
}
\examples{
## Create a 'SIR' demo model with 5 nodes and initialize
## it to run over 10 days.
model <- demo_model(nodes = 5, days = 10, model = "SIR")

## Run the model and save the result
result <- run(model)

## Extract the number of recovered individuals in each
## node after each time step in the simulation
recovered(result)

## Extract the number of recovered individuals in the
## first node after each time step in the simulation
recovered(result, i = 1)

## Extract the number of recovered individuals in the
## first and third node after each time step in the simulation
recovered(result, i = c(1, 3))

## Extract the number of recovered individuals in the first
## and third node after every other time step in the simulation
recovered(result, i = c(1, 3), by = 2)
}
\keyword{methods}
