% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R
\name{select_matrix}
\alias{select_matrix}
\alias{select_matrix,SimInf_model-method}
\title{Extract the select matrix from a \code{SimInf_model} object}
\usage{
select_matrix(model)

\S4method{select_matrix}{SimInf_model}(model)
}
\arguments{
\item{model}{The \code{model} to extract the select matrix
\code{E} from.}
}
\value{
\code{\linkS4class{dgCMatrix}} object.
}
\description{
Utility function to extract \code{events@E} from a
\code{SimInf_model} object, see \code{\linkS4class{SimInf_events}}
}
\examples{
## Create an SIR model
model <- SIR(u0 = data.frame(S = 99, I = 1, R = 0),
             tspan = 1:5, beta = 0.16, gamma = 0.077)

## Extract the select matrix from the model
select_matrix(model)
}
