% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readpars.R
\name{regextract}
\alias{regextract}
\title{Extract (sub)strings matching regex pattern}
\usage{
regextract(x, pattern, ...)
}
\arguments{
\item{x}{a character vector.}

\item{pattern}{regular expression to be found in \code{x}.}

\item{...}{not used.}
}
\value{
a character (string) matrix where the first column contains the global
match for the pattern, each pair of '()' will result in another column with
the respective match.
}
\description{
Extract (sub)strings matching regex pattern.
}
\details{
Extract the substrings of \code{x} that match the regex pattern \code{pattern}.
The pattern may contain groups (enclosed in parentheses) which will result
in further substrings extracted.

Derived from the help on \code{\link[base]{regmatches}}, take a look at the help there
}
\examples{
s <- "Test: A1 BC23 DEF456"
pattern = "([[:alpha:]]+)([[:digit:]]+)"
regextract(s, pattern)

# equivalent to this example from the help page for grep()
lapply(regmatches(s, gregexpr(pattern, s)), function(e) regmatches(e, regexec(pattern, e)))
}
\author{
Benno Pütz \email{puetz@psych.mpg.de}
}
