% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ManipulatePed_Functions.R
\name{censor_ped}
\alias{censor_ped}
\title{Censor pedigree data}
\usage{
censor_ped(ped_file, censor_year = NULL)
}
\arguments{
\item{ped_file}{An object of class \code{ped}. A pedigree generated by \code{sim_ped} or \code{sim_RVped}, or an object created by the function \code{\link{new.ped}}.  See details.}

\item{censor_year}{Numeric. The censor year. If not supplied, defaults to the year the pedigree was ascertained, i.e. the proband's onset year.  See details.}
}
\value{
The censored pedigree.
}
\description{
\code{censor_ped} censors a pedigree of any information that occurs after a specified year.
}
\details{
Upon supplying a pedigree and a censor year the \code{censor_ped} function will remove all individuals born after \code{censor_year} and censor all disease onset and death events after the \code{censor_year}.

Users who wish to use \code{censor_ped} for pedigrees not generated by \code{\link{sim_ped}} or \code{\link{sim_RVped}} must use \code{\link{new.ped}} to create an object of class \code{ped}.  When creating the \code{ped} object please provide as much relevant date information as possible, i.e. years of birth, onset, and death.  When present please specify a proband as described in \code{\link{new.ped}}.

By default, \code{censor_year} is set to the year that the pedigree is ascertained, i.e. the year the proband experienced disease onset. However, if \code{ped_file} does not contain the proband identification variable the user must supply a value for \code{censor_year}.
}
\examples{
#Read in age-specific harard data and create hazard object.
data(AgeSpecific_Hazards)
haz_obj <- hazard(hazardDF = AgeSpecific_Hazards)

#Simulate a pedigree ascertained for multiple affecteds
set.seed(3)
RVped2015 <- sim_RVped(hazard_rates = haz_obj,
                       num_affected = 2,
                       ascertain_span = c(1900, 2015),
                       GRR = 30, carrier_prob = 0.002,
                       RVfounder = TRUE,
                       stop_year = 2015,
                       recall_probs = c(1),
                       founder_byears = c(1900, 1905),
                       FamID = 1)[[2]]

# Plot the 2015 pedigree
plot(RVped2015)
mtext(side = 3, line = 2, "Reference Year: 2017")

# Censor RVped2015 after 1960
RVped1960 <- censor_ped(ped_file = RVped2015, censor_year = 1960)

# Plot the 1960 pedigree
plot(RVped1960)
mtext(side = 3, line = 2, "Reference Year: 1960")

}
\seealso{
\code{\link{new.ped}}
}
