% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LifeSim_Functions.R
\name{get_nextEvent}
\alias{get_nextEvent}
\title{Simulate the next life event}
\usage{
get_nextEvent(current_age, disease_status, RV_status, hazard_rates, GRR,
  carrier_prob, lambda_birth, birth_range, fert = 1)
}
\arguments{
\item{current_age}{Numeric. The individual's current age.}

\item{disease_status}{Numeric. The individual's disease status, where \code{disease_status = 1} if individual has experienced disease onset, otherwise \code{disease_status = 0}.}

\item{RV_status}{Numeric. \code{RV_status = TRUE} if the individual is a carrier of a rare variant that increases disease suseptibility, and \code{FALSE} otherwise.}

\item{hazard_rates}{An object of class \code{hazard}, created by \code{\link{hazard}}.}

\item{GRR}{Numeric. The genetic relative-risk of disease, i.e. the relative-risk of disease for individuals who carry at least one copy of the causal variant.}

\item{carrier_prob}{Numeric.  The carrier probability for all causal variants with relative-risk of disease \code{GRR}.  By default, \code{carrier_prob}\code{ = 0.002}}

\item{lambda_birth}{Numeric. The individual's birth rate.}

\item{birth_range}{Numeric vector of length 2. The minimum and maximum allowable ages, in years, between which this individual may reproduce.}

\item{fert}{Numeric.  A constant used to rescale the fertility rate after disease-onset. By default, \code{fert = 1}.}
}
\value{
A named matrix. The number of years until the next life event,
named by event type.  See Details.
}
\description{
Primarily intended as an internal function, \code{get_nextEvent} randomly simulates an individual's next life event given their current age, disease status, and relative-risk of disease.
}
\details{
Given their current age, \code{get_nextEvent} randomly simulates an individual's next life event by generating waiting times to reproduction, onset, and death.  The event with the shortest waiting time is chosen as the next life event.

We assume that, given an individual's current age, their time to disease onset is the waiting time in a non-homogeneous Poisson process with an age-specific hazard rate that follows a proportional hazards model.  In this model, individuals who have NOT inherited the rare variant experience disease onset according to the baseline (or population) hazard rate of disease.  On the other hand, individuals who have inherited the rare variant are assumed to have an increased risk of disease onset relative to those who have inherited it.  The user is expected to supply the population age-specific hazard rate of disease, the relative-risk of disease for genetic cases, and the population allele frequency of the rare variant.  We impose the restriction that individuals may only experience disease onset once, and remain affected from that point on.

We assume that, given an individual's current age, their time to death is the waiting time in a non-homogeneous Poisson process with age-specific hazard rate determined by their affection status.  We assume that unaffected individuals experience death according to the age-specific hazard rate for death in the unaffected population.  If the disease of interest is sufficiently rare, the user may instead choose to substitute the population age-specific hazard rate for death in the general population.  We assume that affected individuals experience death according to the age-specific hazard rate for death in the affected population.  The user is expected to supply both of these age-specific hazard rates.

We assume that, given an individual's current age, their time to reproduction is the waiting time in a homogeneous Poisson process.  That is, we assume that individuals reproduce at uniform rate during their reproductive years.  For example, one's reproductive years may span from age 18 to age 45.  We do not allow for offspring to be produced outside of an individual's \code{birth_range}.

If get_nextEvent returns the waiting time to the next life event, named for event type.  The possible event types are as follows:
\itemize{
 \item "Child" a reproductive event, i.e. creation of offspring
 \item "Onset" disease onset event,
 \item "Death" death event
}
}
\keyword{internal}
