% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sim_reg_mc}
\alias{sim_reg_mc}
\title{Gets summarised output of multiple \code{sim_reg} chains}
\usage{
sim_reg_mc(ontology, y, x, g = rep(0, length(y)), its = 10000, chains = 3,
  cores = 1, information_content = get_term_info_content(ontology, term_sets
  = x), term_descendancy_matrix = get_term_descendancy_matrix(ontology,
  names(information_content)), term_sim_mat = prune_sim_mat(ontology,
  get_term_sim_mat(ontology, information_content, term_descendancy_matrix =
  term_descendancy_matrix)), ...)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{y}{Logical vector of genotypes (typically TRUE for rare genotype, FALSE for common genotype).}

\item{x}{List of character vectors of terms IDs.}

\item{g}{Genotype log odds offset per individual.}

\item{its}{Number of update cycles to perform .}

\item{chains}{Number of independent Markov chains used to obtain estimates.}

\item{cores}{Number of cores to use in parallel computation.}

\item{information_content}{Numeric vector, named by HPO IDs, containing the information content of corresponding terms.}

\item{term_descendancy_matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO.}

\item{term_sim_mat}{Numeric matrix with rows and columns corresponding to (and named by) term IDs, and cells containing the similarity between the row and column term}

\item{...}{Other arguments to be passed to \code{\link{sim_reg}}.}
}
\value{
\code{sim_reg_samples} object.
}
\description{
Simple interface to the \code{sim_reg} procedure returning a \code{sim_reg_summary}.

Performns Bayesian `similarity regression' on given binary genotype \code{y} (logical vector) against ontological term sets \code{x} (list of character vectors of term IDs). This could, for example, be a \code{list} of character vectors of HPO term IDs representing case phenotypes. It returns an object of class \code{sim_reg_samples}, which is a list of traces for the sampled parameters. The results can be summarised with \code{summary}. Of particular interest are the estimated mean posteriors of \code{gamma} (the model selection indicator, thus giving an estimate of the probability of an association under the model assumptions - stored in the `mean_posterior_gamma' slot in the result, i.e. \code{result$mean_posterior_gamma}, and the characteristic ontological profile phi (which can be visualised by the functions \code{\link{phi_plot}}, \code{\link{term_pair_marginals_plot}}, and \code{\link{term_marginals}}).
}
\seealso{
\code{\link{sim_reg}}
}

