% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizeestima.R
\name{sizeestima}
\alias{sizeestima}
\title{Estimating the sizes of populations who inject drugs
from multiple data sources using a Bayesian hierarchical model.}
\usage{
sizeestima(DATA, size, burnin, thin)
}
\arguments{
\item{DATA}{dataset from Bangladesh which used in Bao L, Raftery A, Reddy A. (2015) Estimating the Sizez of Populations At Risk of HIV Infection From Multiple Data Sources Using a Bayesian Hierarchical Model, Statistics and Its Interface.}

\item{size}{the number of iteration in MCMC algorithm.}

\item{burnin}{the number of Burn-In in MCMC algorithm.}

\item{thin}{keep every thin-th scan.}
}
\value{
A matrix of posterior samples of at-risk population sizes at the sub-national level, where the rows correspond to sub-national areas and the columns correspond to MCMC iterations.
}
\description{
This R package is for reproducing Bao L, Raftery A, Reddy A. (2015) Estimating the Sizes of Populations At Risk of HIV Infection From Multiple Data Sources Using a Bayesian Hierarchical Model, Statistics and Its Interface. This function develops an algorithm for presenting a Bayesian hierarchical
model for estimating the sizes of drug injected
populations in Bangladesh. The model incorporates multiple commonly used data sources
including mapping data, surveys, interventions, capture-recapture data,
estimates or guesstimates from organizations, and expert opinion. This function provides the posterior samples of burnin thin at-risk population sizes at the subnational level.
}
\details{
This function runs MCMC algorithm for reproducing Bao L, Raftery A, Reddy A. (2015) Estimating the Sizez of Populations At Risk of HIV Infection From Multiple Data Sources Using a Bayesian Hierarchical Model, Statistics and Its Interface.
}
\examples{
#n.total=sizeestima(DATA,500000,501,100)
}
\author{
Le Bao, Adrian E. Raftery, Kyongwon Kim
}
\references{
Bao L, Raftery A, Reddy A. (2015) Estimating the Sizes of Populations At Risk of HIV Infection From Multiple Data Sources Using a Bayesian Hierarchical Model, Statistics and Its Interface.
}
\seealso{
\code{\link{rtnorm} \link{rinvgamma} \link{dtnorm}}
}

