% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPath.R
\name{getPath}
\alias{getPath}
\title{Get the path of a vector of filenames}
\usage{
getPath(vec)
}
\arguments{
\item{vec}{Character vector (usually containing filenames)}
}
\value{
Character vector with pathnames only, the filename removed
}
\description{
Get the path of a vector of filenames
}
\details{
Assumes paths are delineated using forward slashes.  If an \code{NA} is
supplied, then an \code{NA} is returned.  If the desired string doesn't
exist (see examples below), a \code{""} is returned.
}
\examples{
getPath(c(a="this.good.path/filename.R", b="nopath.R", c="/", d=NA,
          e="path1/path2/", ""))

# An example with 'real' files
files <- dir(file.path(path.package(package = "Smisc"), "data"), full.names = TRUE)
print(files)
getPath(files)
}
\seealso{
Additional functions for filename manipulations:  \code{\link{stripExtension}}, \code{\link{getExtension}},
\code{\link{stripPath}}, \code{\link{grabLast}}, \code{\link{basename}}, \code{\link{dirname}}
}
\author{
Landon Sego
}
\keyword{misc}
