\name{predict.idm}
\alias{predict.idm}
\title{Predictions for an illness-death model using either a penalized likelihood
approach or a Weibull parametrization.}
\usage{
\method{predict}{idm}(object, s, t, Z01, Z02, Z12, nsim = 2000, CI = TRUE,
  ...)
}
\arguments{
  \item{object}{an \code{idm} class objects returned by a
  call to the \code{\link{idm}} function}

  \item{s}{time at prediction.}

  \item{t}{time for prediction.}

  \item{Z01}{vector for the values of the covariates on the
  transition 0 --> 1 (in the same order as the covariates
  within the call. The default values are all 0.}

  \item{Z02}{vector for the values of the covariates on the
  transition 0 --> 2 (in the same order as the covariates
  within the call. The default values are all 0.}

  \item{Z12}{vector for the values of the covariates on the
  transition 1 --> 2 (in the same order as the covariates
  within the call. The default values are all 0.}

  \item{nsim}{number of simulations for the confidence
  intervals calculations. The default is 2000.}

  \item{CI}{boolean: with (\code{TRUE}) or without
  (\code{WRONG}) confidence intervals for the predicted
  values. The default is \code{TRUE}.}

  \item{\dots}{other parameters.}
}
\value{
a list containing the following predictions with pointwise
confidence intervals: \item{p00}{the transition probability
\eqn{p_{00}}.} \item{p01}{the transition probability
\eqn{p_{01}}.} \item{p11}{the transition probability
\eqn{p_{11}}.} \item{p12}{the transition probability
\eqn{p_{12}}.} \item{p02_0}{the probability of direct
transition from state 0 to state 2.} \item{p02_1}{the
probability of transition from state 0 to state 2 via state
1.} \item{p02}{transition probability \eqn{p_{02}}. Note
that \code{p02}=\code{p_02_0}+\code{p02_1}.} \item{F01}{the
lifetime risk of disease.
\code{F01}=\code{p01}+\code{p02_1}.} \item{F0.}{the
probability of exit from state 0.
\code{F0.}=\code{p02_0}+\code{p01}+\code{p02_1}.}
}
\description{
Predict transition probabilities and cumulative
probabilities from an object of class \code{idmSplines}
with confidence intervals are calculated.
}
\examples{
\dontrun{
data(Paq1000)
library(prodlim)
fit <- idm(formula02=Hist(time=t,event=death,entry=e)~certif,
formula01=Hist(time=list(l,r),event=dementia)~certif,data=Paq1000)

pred <- predict(fit,s=70,t=80,Z01=c(1),Z02=c(1),Z12=c(1))
pred

fit.splines <-  idm(formula02=Hist(time=t,event=death,entry=e)~certif,
		formula01=Hist(time=list(l,r),event=dementia)~certif,
                formula12=~1,
                method="Splines",
		data=Paq1000)

pred <- predict(fit.splines,s=70,t=80,Z01=c(1),Z02=c(1))
pred

}
}
\author{
R: Celia Touraine <Celia.Touraine@isped.u-bordeaux2.fr>
Fortran: Pierre Joly <Pierre.Joly@isped.u-bordeaux2.fr>
}
\seealso{
\code{\link{idm}}
}
\keyword{methods}

