% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RoughClustering.r
\name{RoughKMeans_SHELL}
\alias{RoughKMeans_SHELL}
\title{Rough k-Means Shell}
\usage{
RoughKMeans_SHELL(clusterAlgorithm, dataMatrix, meansMatrix, nClusters, 
                  normalizationMethod, maxIterations, plotDimensions, 
                  colouredPlot, threshold, weightLower)
}
\arguments{
\item{clusterAlgorithm}{Select 0 = classic k-means, 1 = Lingras & West's rough k-means, 2 = Peters' rough k-means, 3 = \eqn{\pi} rough k-means. Default: clusterAlgorithm = 3 (\eqn{\pi} rough k-means).}

\item{dataMatrix}{Matrix with the objects to be clustered. Dimension: [nObjects x nFeatures].}

\item{meansMatrix}{Select means derived from 1 = random (unity interval), 2 = maximum distances, matrix [nClusters x nFeatures] = self-defined means. Default: 2 = maximum distances.}

\item{nClusters}{Number of clusters: Integer in [2, nObjects). Note, nCluster must be set even when meansMatrix is a matrix. For transparency, nClusters will not be overridden by the number of clusters derived from meansMatrix. Default: nClusters=2. Note: Plotting is limited to a maximum of 5 clusters.}

\item{normalizationMethod}{1 = unity interval, 2 = normal distribution (sample variance), 3 = normal distribution (population variance). Any other value returns the matrix unchanged. Default: meansMatrix = 1 (unity interval).}

\item{maxIterations}{Maximum number of iterations. Default: maxIterations=100.}

\item{plotDimensions}{An integer vector of the length 2. Defines the to be plotted feature dimensions, i.e., max(plotDimensions = c(1:2)) <= nFeatures. Default: plotDimensions = c(1:2).}

\item{colouredPlot}{Select TRUE = colouredPlot plot, FALSE = black/white plot.}

\item{threshold}{Relative threshold in rough k-means algorithms (threshold >= 1.0).  Default: threshold = 1.5. Note: It can be ignored for classic k-means.}

\item{weightLower}{Weight of the lower approximation in rough k-means algorithms (0.0 <= weightLower <= 1.0).  Default: weightLower = 0.7. Note: It can be ignored for classic k-means and \eqn{\pi} rough k-means}
}
\value{
2D-plot of clustering results. The boundary objects are represented by stars (*).

\code{$upperApprox}: Obtained upper approximations [nObjects x nClusters]. Note: Apply function \code{createLowerMShipMatrix()} to obtain lower approximations; and for the boundary: \code{boundary = upperApprox - lowerApprox}.

\code{$clusterMeans}: Obtained means [nClusters x nFeatures].

\code{$nIterations}: Number of iterations.
}
\description{
RoughKMeans_SHELL performs rough k-means algorithms with  options for normalization and a 2D-plot of the results.
}
\examples{
# An illustrative example clustering the sample data set DemoDataC2D2a.txt
RoughKMeans_SHELL(3, DemoDataC2D2a, 2, 2, 1, 100, c(1:2), TRUE, 1.5, 0.7)
}
\references{
Lloyd, S.P. (1982) Least squares quantization in PCM. \emph{IEEE Transactions on Information Theory} \bold{28}, 128--137. <doi:10.1016/j.ijar.2012.10.003>.

Lingras, P. and West, C. (2004) Interval Set Clustering of web users with rough k-means. \emph{Journal of Intelligent Information Systems} \bold{23}, 5--16. <doi:10.1023/b:jiis.0000029668.88665.1a>.

Peters, G. (2006) Some refinements of rough k-means clustering. \emph{Pattern Recognition} \bold{39}, 1481--1491. <doi:10.1016/j.patcog.2006.02.002>.

Lingras, P. and Peters, G. (2011) Rough Clustering. \emph{WIREs Data Mining and Knowledge Discovery} \bold{1}, 64--72. <doi:10.1002/widm.16>.

Lingras, P. and Peters, G. (2012) Applying rough set concepts to clustering. In: Peters, G.; Lingras, P.; Slezak, D. and Yao, Y. Y. (Eds.) \emph{Rough Sets: Selected Methods and Applications in Management and Engineering}, Springer, 23--37. <doi:10.1007/978-1-4471-2760-4_2>.

Peters, G.; Crespo, F.; Lingras, P. and Weber, R. (2013) Soft clustering -- fuzzy and rough approaches and their extensions and derivatives. \emph{International Journal of Approximate Reasoning} \bold{54}, 307--322. <doi:10.1016/j.ijar.2012.10.003>.

Peters, G. (2014) Rough clustering utilizing the principle of indifference. \emph{Information Sciences} \bold{277}, 358--374. <doi:10.1016/j.ins.2014.02.073>.

Peters, G. (2015) Is there any need for rough clustering?  \emph{Pattern Recognition Letters} \bold{53}, 31--37. <doi:10.1016/j.patrec.2014.11.003>.
}
\author{
M. Goetz, G. Peters, Y. Richter, D. Sacker, T. Wochinger.
}
