\name{fW.Moyano}
\alias{fW.Moyano}
\title{Effects of moisture on decomposition rates according to the function proposed by Moyano et al. (2013)}
\description{Calculates the effects of water content on decomposition rates.}
\usage{fW.Moyano(theta, a = 3.11, b = 2.42)}
\arguments{
  \item{theta}{A scalar or vector containing values of volumetric soil water content.}
  \item{a}{Empirical parameter}
  \item{b}{Empirical parameter}
}


\references{F. E. Moyano, S. Manzoni, C. Chenu. 2013
Responses of soil heterotrophic respiration to moisture availability: An exploration of processes and models. 
Soil Biology and Biochemistry, Volume 59, April 2013, Pages 72-85}
\author{Carlos A. Sierra <csierra@bgc-jena.mpg.de>, Markus Mueller <mamueller@bgc-jena.mpg.de>}




\examples{
th=seq(0,1,0.01)
xi=fW.Moyano(theta=th)
plot(th,xi,type="l",main="Effects of soil water content on decomposition rates",
     xlab="Volumetric soil water content (cm3 cm-3)",ylab=expression(xi))
}
