% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTaxonAtLevel.R
\name{getTaxonAtLevel}
\alias{getTaxonAtLevel}
\title{Get the Taxon Name at the Soil Taxonomic Order, Suborder, Great Group or Subgroup Level}
\usage{
getTaxonAtLevel(x, level = c("order", "suborder", "greatgroup", "subgroup"))
}
\arguments{
\item{x}{A character vector containing subgroup-level taxonomic names}

\item{level}{one of \code{c("order","suborder","greatgroup","subgroup")}}
}
\value{
A named character vector of taxa at specified level, where names are the internal Soil Taxonomy letter codes.
}
\description{
Get the Taxon Name at the Soil Taxonomic Order, Suborder, Great Group or Subgroup Level
}
\examples{

# default gets the soil order 
getTaxonAtLevel(c("typic haplargids", "typic glacistels")) #, level = "order")

# specify alternate levels
getTaxonAtLevel("humic haploxerands", level = "greatgroup")

# can't get subgroup (child) from great group (parent)
getTaxonAtLevel("udifolists", level = "subgroup")

# but can do parents of children
getTaxonAtLevel("udifolists", level = "suborder")

}
\author{
A.G. Brown
}
