% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-spades.R
\name{doEvent}
\alias{doEvent}
\title{Process a simulation event}
\usage{
doEvent(sim, debug, notOlderThan)
}
\arguments{
\item{sim}{Character string for the \code{simList} simulation object.}

\item{debug}{Optional. Either Logical or character. If logical, entire \code{simList}
will be printed at each event. If a character string, then it can be one
of the many simList accessors, such as \code{events}, \code{params}.
It can also be any R expression that will be evaluated with access
to the \code{sim} object.
If \code{"current"} is used, then it will be a compact list of the events
as they go by.}

\item{notOlderThan}{Date or time. Passed to \code{reproducible::Cache} to update the cache.
Default is \code{NULL}, meaning don't update the cache.
If \code{Sys.time()} is provided, then it will force a recache,
i.e., remove old value and replace with new value.
Ignored if \code{cache} is \code{FALSE}.}
}
\value{
Returns the modified \code{simList} object.
}
\description{
Internal function called from \code{spades}.
}
\details{
Calls the module corresponding to the event call, and executes the event.

Here, we implement a simulation in a more modular fashion so it's easier to add
submodules to the simulation. We use S4 classes and methods, and use `data.table`
instead of `data.frame` to implement the event queue (because it is much faster).
}
\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3).
            San Fransisco, CA: No Starch Press, Inc..
            Retrieved from \url{https://www.nostarch.com/artofr.htm}
}
\author{
Alex Chubaty
}
\keyword{internal}
