% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{citation}
\alias{citation}
\alias{citation,simList-method}
\alias{citation,character-method}
\title{A citation method for \code{SpaDES} modules}
\usage{
citation(package, lib.loc = NULL, auto = NULL, module = character())

\S4method{citation}{simList}(package, lib.loc = NULL, auto = NULL, module = character())

\S4method{citation}{character}(package, lib.loc = NULL, auto = NULL, module = character())
}
\arguments{
\item{package}{For compatibility with \code{\link[utils:citation]{utils::citation()}}. This can be
a \code{simList} or a character string for a package name.}

\item{lib.loc}{a character vector with path names of \R libraries, or
    the directory containing the source for \code{package}, or
    \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  If the default is used, the loaded
    packages are searched before the libraries.}

\item{auto}{a logical indicating whether the default citation
    auto-generated from the package \file{DESCRIPTION} metadata should
    be used or not, or \code{NULL} (default), indicating that a
    \file{CITATION} file is used if it exists, or an object of class
    \code{"\link[utils]{packageDescription}"} with package metadata (see
    below).}

\item{module}{Optional character string indicating which module params should come from.}
}
\value{
The citation information for a SpaDES module.
}
\description{
This is a wrapper around \code{\link[utils:citation]{utils::citation()}} for cases with \code{package} is a
\code{character} string. Otherwise, it takes a \code{simList}.
}
