% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{times}
\alias{.callingFrameTimeunit}
\alias{.callingFrameTimeunit,.simList-method}
\alias{.callingFrameTimeunit,NULL-method}
\alias{end}
\alias{end,.simList,character-method}
\alias{end,.simList,missing-method}
\alias{end<-}
\alias{end<-,.simList-method}
\alias{simList-accessors-times}
\alias{start}
\alias{start,.simList,character-method}
\alias{start,.simList,missing-method}
\alias{start<-}
\alias{start<-,.simList-method}
\alias{time}
\alias{time,.simList,character-method}
\alias{time,.simList,missing-method}
\alias{time<-}
\alias{time<-,.simList-method}
\alias{times}
\alias{times,.simList-method}
\alias{times<-}
\alias{times<-,.simList-method}
\alias{timeunit}
\alias{timeunit,.simList-method}
\alias{timeunit<-}
\alias{timeunit<-,.simList-method}
\alias{timeunits}
\alias{timeunits,.simList-method}
\title{Time usage in \code{SpaDES}}
\usage{
times(x, ...)

\S4method{times}{.simList}(x)

times(x) <- value

\S4method{times}{.simList}(x) <- value

time(x, unit, ...)

\S4method{time}{.simList,missing}(x)

\S4method{time}{.simList,character}(x, unit)

time(x) <- value

\S4method{time}{.simList}(x) <- value

end(x, unit, ...)

\S4method{end}{.simList,missing}(x)

\S4method{end}{.simList,character}(x, unit)

end(x) <- value

\S4method{end}{.simList}(x) <- value

start(x, unit, ...)

\S4method{start}{.simList,missing}(x)

\S4method{start}{.simList,character}(x, unit)

start(x) <- value

\S4method{start}{.simList}(x) <- value

.callingFrameTimeunit(x)

\S4method{.callingFrameTimeunit}{.simList}(x)

\S4method{.callingFrameTimeunit}{`NULL`}(x)

timeunit(x)

\S4method{timeunit}{.simList}(x)

timeunit(x) <- value

\S4method{timeunit}{.simList}(x) <- value

timeunits(x)

\S4method{timeunits}{.simList}(x)
}
\arguments{
\item{x}{A \code{simList} simulation object.}

\item{...}{Additional parameters.}

\item{value}{A time, given as a numeric, optionally with a unit attribute, but this
will be deduced from the model time units or module time units (if used
within a module)}

\item{unit}{Character. One of the time units used in \code{SpaDES}.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Functions for the \code{simtimes} slot of a \code{simList} object
and its elements. To maintain modularity, the behavior of these functions depends
on where they are used. In other words, different modules can have their own
timeunit. \code{SpaDES} converts these to seconds when running a simulation, but
shows the user time in the units of the model as shown with \code{timeunit(sim)}
}
\details{
NOTE: These have default behavior that is based on the calling
frame timeunit. When used inside a module, then the time is in the units of the module.
If used in an interactive mode, then the time will be in the units of the spades
simulation.

Additonal methods are provided to access the current, start, and end times
of the simulation:
\tabular{ll}{
   \code{time} \tab Current simulation time.\cr
   \code{start} \tab Simulation start time.\cr
   \code{end} \tab Simulation end time.\cr
   \code{timeunit} \tab Simulation timeunit.\cr
   \code{timeunits} \tab Module timeunits.\cr
   \code{times} \tab List of all simulation times (current, start, end, timeunit).\cr
}

\code{timeunit} will extract the current units of the time used in a
simulation (i.e., within a \code{spades} call).
If it is set within a \code{simInit}, e.g.,
\code{times=list(start=0, end=52, timeunit = "week")}, it will set the
units for that simulation.
By default, a \code{simInit} call will use the smallest unit contained within
the metadata for the modules being used.
If \code{NA}, \code{timeunit} defaults to none.

Currently, available units are "second", "hours", day", "week", "month", and
"year" can be used in the metadata of a module.

The user can also define a new unit. The unit name can be anything, but the
function definition must be of the form, dunitName, e.g., dyear or dfortnight.
The unit name is the part without the 'd' and the function name definition
includes the 'd'. This new function, e.g.,
\code{dfortNight <- function(x) lubridate::duration(dday(14))}
can be placed anywhere in the search path or in a module.

\code{timeunits} will extract the current units of the time of all
modules used in a simulation.
This is different from \code{timeunit} because it is not necessarily
associated with a \code{spades} call.

In many cases, the "simpler" use of each of these functions may be slower
computationally. For instance, it is much faster to use \code{time(sim, "year")}
than \code{time(sim)}. So as a module developer, it is advantageous to
write out the longer one, minimizing the looking up that R must do.
}
\author{
Alex Chubaty and Eliot McIntire

Eliot McIntire
}
\seealso{
\code{\link{simList-class}},
         \code{\link{simList-accessors-envir}},
         \code{\link{simList-accessors-events}},
         \code{\link{simList-accessors-inout}},
         \code{\link{simList-accessors-modules}},
         \code{\link{simList-accessors-objects}},
         \code{\link{simList-accessors-params}},
         \code{\link{simList-accessors-paths}}.
}

