% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-diagrams.R
\docType{methods}
\name{eventDiagram}
\alias{eventDiagram}
\alias{eventDiagram,simList,missing,character-method}
\alias{eventDiagram,simList,missing,missing-method}
\alias{eventDiagram,simList,numeric,character-method}
\title{Simulation event diagram}
\usage{
eventDiagram(sim, n, startDate, ...)

\S4method{eventDiagram}{simList,numeric,character}(sim, n, startDate, ...)

\S4method{eventDiagram}{simList,missing,character}(sim, n, startDate, ...)

\S4method{eventDiagram}{simList,missing,missing}(sim, n, startDate, ...)
}
\arguments{
\item{sim}{A \code{simList} object (typically corresponding to a
completed simulation).}

\item{n}{The number of most recently completed events to plot.}

\item{startDate}{A character representation of date in YYYY-MM-DD format.}

\item{...}{Additional arguments passed to \code{mermaid}.
Useful for specifying \code{height} and \code{width}.}
}
\value{
Plots an event diagram as Gantt Chart, invisibly returning a \code{mermaid} object.
}
\description{
Create a Gantt Chart representing the events in a completed simulation.
This event diagram is constructed using the completed event list
To change the number of events shown, provide an \code{n} argument.
}
\details{
Simulation time is presented on the x-axis, starting at date 'startDate'.
Each module appears in a color-coded row, within which each event for that
module is displayed corresponding to the sequence of events for that module.
Note that only the start time of the event is meaningful is these figures:
the width of the bar associated with a particular module's event DOES NOT
correspond to an event's "duration".

Based on this StackOverflow answer: \url{http://stackoverflow.com/a/29999300/1380598}.
}
\note{
A red vertical line corresponding to the current date may appear on the figure.
This is useful for Gantt Charts generally but can be considered a 'bug' here.
}
\author{
Alex Chubaty
}
\seealso{
\code{\link[DiagrammeR]{mermaid}}.
}

