% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{checkallmodels}
\alias{checkallmodels}
\title{Check all possible models}
\usage{
checkallmodels(zdata, verbose = F)
}
\arguments{
\item{zdata}{Data matrix with \eqn{t+1} columns. The first \eqn{t} columns, each corresponding to a particular list,
are 0s and 1s defining the capture histories
observed. The last column is the count of cases with that particular capture history.
List names A, B, ... are constructed if not supplied. Where a capture history is not explicitly listed,
it is assumed that it has observed count zero.}

\item{verbose}{Specifies whether all possible models are listed in the output, or only those which generate a non-zero error code.}
}
\value{
If \code{verbose=F}, it gives a matrix each of whose rows specifies a model, with last entry equal to the error code.  Only those models yielding a non-zero error code are included, so if no models lead to an error the matrix is empty. Each of the first \eqn{t(t-1)/2} columns corresponds to a pair of lists, and for each row, presence in or absence from the corresponding model is indicated by the value 1 or 0 respectively.

If \code{verbose=T}, it gives the full matrix of models together with the error codes they generate.
}
\description{
This routine checks every possible model for existence and identifiability of the maximum likelihood estimates.
}
\details{
The routine calls the routine \code{\link{checkident}} for every model.
 If there are \eqn{t} lists then there are \eqn{t(t-1)/2} pairs of lists, and hence \eqn{2^{t(t-1)/2}} possible models, because
  the models correspond to subsets of the set of all pairs of lists.   If \eqn{t = 7} there are 2,097,152 models to check, which would take
  several hours.   If \eqn{t} is equal to 8 or more, the routine terminates with a statement of the number of models and an explanation that
  checking all of these is not possible in a reasonable time.
}
\examples{
data(Artificial_3)
data(Western)
checkallmodels(Artificial_3, verbose= TRUE)
checkallmodels(Western)
}
