% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rankhist.R
\name{Rankhist}
\alias{Rankhist}
\title{Rank histogram for ensemble forecasts}
\usage{
Rankhist(ens, obs, reduce.bins = 1, handle.na = "na.fail")
}
\arguments{
\item{ens}{matrix of dimension (N,K). An archive of K-member ensemble forecasts for N time instances.}

\item{obs}{vector of length N. The corresponding verifying observations.}

\item{reduce.bins}{number of adjacent bins that will be merged into one bin; has to be a divisor of K+1}

\item{handle.na}{how should missing values in ensemble and observation data be handled; possible values are 'na.fail' (fails if any data is missing) and 'use.complete' (only uses times where all ensemble members and obs are available); default: 'na.fail'}
}
\value{
a vector of length (K+1)/reduce.bins containing the rank counts
}
\description{
Calculate the rank histogram for an archive of ensemble forecasts and their corresponding verifying observations.
}
\examples{
data(eurotempforecast)
rh <- Rankhist(ens, obs)
}
\references{
Anderson J.L. (1996). A Method for Producing and Evaluating Probabilistic Forecasts from Ensemble Model Integrations. J. Climate, 9, 1518--1530. DOI 10.1175/1520-0442(1996)009%3C1518:AMFPAE%3E2.0.CO;2.
Hammill T.M. (2001). Interpretation of Rank Histograms for Verifying Ensemble Forecasts. Mon. Wea. Rev., 129, 550--560. DOI 10.1175/1520-0493(2001)129%3C0550:IORHFV%3E2.0.CO;2.
}
\seealso{
PlotRankhist, TestRankhist
}

