% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logbreaks.R
\name{logbreaks}
\alias{logbreaks}
\title{logbreaks}
\usage{
logbreaks(
  x,
  parlist = list(alpha, J),
  round_breaks = 0,
  plot_breaks = FALSE,
  effect.threshold.begin = NA,
  effect.threshold.end = NA
)
}
\arguments{
\item{x}{either a numeric vector to be partitioned or a numeric vector
containing the minimum and maximum of the vector to be partitioned.}

\item{parlist}{a list of 2 elements. The first one is alpha, a numeric and
positive value. It is a parameter affecting the number of breaks closed to
the minimum. The second one is J. It is a nonnegative and nonzero integer and
represent the selected number of classes.}

\item{round_breaks}{a nonnegative integer. Equal to 0 by default, it is the
number of decimal values of the breaks.}

\item{plot_breaks}{logical. FALSE by default. If TRUE, the breaks are
plotted.}

\item{effect.threshold.begin}{NA by default. Numeric value between the
minimum and maximum of x. If it isn't NA, the first class is created with
xmin and effect.threshold.begin.}

\item{effect.threshold.end}{NA by default. Numeric value between the minimum
and maximum of x. If it isn't NA, the last class is created with xmax and
effect.threshold.end.}
}
\value{
The return is a numeric vector of length J+1 with the breaks
obtained following a log scale.
}
\description{
A function that allows to obtain histogram class limits following a
logarithmic scale. It also has a parameter that allows to set the scale at
your convenience.
}
\details{
The breaks are obtained as follows: 

\deqn{L(w) = \min(x) + \frac{e^{\alpha \frac{w-1}{J}} - 1 }{e^{\alpha}-1} 
(\max(x) -\min(x)), \  w= 1, \ldots, J+1.}
}
\examples{
logbreaks(c(10,1000), parlist=list(0.2,5))
logbreaks(c(10,1000), parlist=list(0.2,5),plot_breaks=TRUE)
}
