% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_weibull.R
\name{submod_weibull}
\alias{submod_weibull}
\title{Subgroup Identification: Model-based partitioning (Weibull)}
\usage{
submod_weibull(Y, A, X, Xtest, mu_train, minsize = floor(dim(X)[1] *
  0.05), maxdepth = 4, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate matrix. Must be numeric.}

\item{Xtest}{Test set}

\item{mu_train}{Patient-level estimates (See PLE_models)}

\item{minsize}{Minimum number of observations in a tree node.
Default = floor( dim(train)[1]*0.05  )}

\item{maxdepth}{Maximum depth of any node in the tree (default=4)}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
MOB (Weibull) model, predictions, and identified subgroups.
 \itemize{
  \item mod - MOB (Weibull) model object
  \item Subgrps.train - Identified subgroups (training set)
  \item Subgrps.test - Identified subgroups (test set)
  \item pred.train - Predictions (training set)
  \item pred.test - Predictions (test set)
}
}
\description{
Uses the MOB (with weibull loss function) algorithm to identify subgroups.
Usable for survival outcomes.
}
\examples{
library(StratifiedMedicine)


\donttest{
## Load TH.data (no treatment; generate treatment randomly to simulate null effect) ##
data("GBSG2", package = "TH.data", envir = e <- new.env() )
surv.dat = e$GBSG2
## Design Matrices ###
Y = with(surv.dat, Surv(time, cens))
X = surv.dat[,!(colnames(surv.dat) \%in\% c("time", "cens")) ]
A = rbinom( n = dim(X)[1], size=1, prob=0.5  )
res_weibull = submod_weibull(Y, A, X, Xtest=X, family="survival")
plot(res_weibull$mod)
}

}
\seealso{
\code{\link{PRISM}}, \code{\link{mob}}
}
