% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_rpart.R
\name{submod_rpart}
\alias{submod_rpart}
\title{Subgroup Identification: CART (rpart)}
\usage{
submod_rpart(Y, A, X, Xtest, mu_train, minbucket = floor(dim(X)[1] *
  0.1), maxdepth = 4, outcome_PLE = FALSE, family = "gaussian", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{mu_train}{Patient-level estimates (See PLE_models)}

\item{minbucket}{Minimum number of observations in a tree node.
Default = floor( dim(train)[1]*0.05  )}

\item{maxdepth}{Maximum depth of any node in the tree (default=4)}

\item{outcome_PLE}{If TRUE, use PLE as outcome (mu_train must contain PLEs).
Else use observed outcome Y}

\item{family}{Outcome type ("gaussian", "binomial"), default is "gaussian"}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained rpart (CART).
 \itemize{
  \item mod - rpart model as partykit object
}
}
\description{
Uses the CART algorithm (rpart) to identify subgroups. Usable for continuous and binary
outcomes. Option to use the observed outcome or PLEs for subgroup identification.
}
\examples{

\donttest{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

require(rpart)
res_rpart1 = submod_rpart(Y, A, X, Xtest=X)
res_rpart2 = submod_rpart(Y, A, X, Xtest=X, maxdepth=2, minbucket=100)
plot(res_rpart1$mod)
plot(res_rpart2$mod)
}


}
\references{
Breiman L, Friedman JH, Olshen RA, and Stone CJ. (1984) Classification 
and Regression Trees. Wadsworth
}
