% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbs.R
\name{fbs}
\alias{fbs}
\title{Fast Balanced Sampling}
\usage{
fbs(X, strata, pik)
}
\arguments{
\item{X}{A matrix of size (\eqn{N} x \eqn{p}) of auxiliary variables on which the sample must be balanced.}

\item{strata}{A vector of integers that specifies the stratification.}

\item{pik}{A vector of inclusion probabilities.}
}
\value{
A vector with elements equal to 0 or 1. The value 1 indicates that the unit is selected while the value 0 is for rejected units.
}
\description{
This function implements the method proposed by Hasler and Tillé (2014). It should be used for selecting a sample from highly stratified population.
}
\details{
Firstly a flight phase is performed on each strata. Secondly, several flight phases are applied by adding one by one the stratum. By doing this, some strata are managed on-the-fly. Finally, a landing phase is applied by suppression of the variables. If the number of element selected in each stratum is not equal to an integer, the function can be very time-consuming.
}
\examples{

N <- 100
n <- 10
x1 <- rgamma(N,4,25)
x2 <- rgamma(N,4,25)

strata <- rep(1:n,each = N/n)

pik <- rep(n/N,N)
X <- as.matrix(cbind(matrix(c(x1,x2),ncol = 2)))

s <- fbs(X,strata,pik)

t(X/pik)\%*\%s
t(X/pik)\%*\%pik

Xcat <- disj(strata)

t(Xcat)\%*\%s
t(Xcat)\%*\%pik


}
\references{
Hasler, C. and Tillé Y. (2014). Fast balanced sampling for highly stratified population. \emph{Computational Statistics and Data Analysis}, 74, 81-94
}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
