% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc_get_params.R
\name{lc_get_metric_names}
\alias{lc_get_metric_names}
\title{Get LakeCat Metric Names}
\usage{
lc_get_metric_names(category = NULL, aoi = NULL, year = NULL, dataset = NULL)
}
\arguments{
\item{category}{Filter LakeCat metrics based on the metric category}

\item{aoi}{Filter LakeCat metrics based on the area of interest}

\item{year}{Filter LakeCat metrics based on a particular year or years}

\item{dataset}{Filter LakeCat metrics based on the dataset name}
}
\value{
A dataframe of merics and description that match filter criteria
}
\description{
Function to filter LakeCat metrics metrics by category, area of interest,
dataset or year. Use `lc_get_params(categories)` or `lc_get_params(datasets)`
to see all the valid category or dataset options
}
\examples{
\dontrun{
metrics <- lc_get_metric_names(category='Natural')
metrics <- lc_get_metric_names(category = c('Anthropogenic','Natural'),
aoi=c('Cat','Ws'))}
}
\author{
Marc Weber
}
