% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit_SurvSurv.R
\name{marginal_gof_scr}
\alias{marginal_gof_scr}
\title{Marginal survival function goodness of fit}
\usage{
marginal_gof_scr(fitted_model, data, grid, time_unit = "years")
}
\arguments{
\item{fitted_model}{Returned value from \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}. This object
essentially contains the estimated identifiable part of the joint
distribution for the potential outcomes.}

\item{data}{data that was supplied to \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}.}

\item{grid}{grid of time-points for which to compute the estimated survival
functions.}

\item{time_unit}{character vector that reflects the time unit of the
endpoints, defaults to \code{"years"}.}
}
\description{
The \code{\link[=marginal_gof_scr]{marginal_gof_scr()}} function plots the estimated marginal survival
functions for the fitted model. This results in four plots of survival
functions, one for each of \eqn{S_0}, \eqn{S_1}, \eqn{T_0}, \eqn{T_1}.
}
\examples{
library(Surrogate)
data("Ovarian")
#For simplicity, data is not recoded to semi-competing risks format, but is
#left in the composite event format.
data = data.frame(
  Ovarian$Pfs,
  Ovarian$Surv,
  Ovarian$Treat,
  Ovarian$PfsInd,
  Ovarian$SurvInd
)
ovarian_fitted =
  fit_model_SurvSurv(data = data,
                     copula_family = "clayton",
                     n_knots = 1)
grid = seq(from = 0, to = 2, length.out = 200)
marginal_gof_scr(ovarian_fitted, data, grid)

}
