% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyticSurvBin.R
\name{summary.MetaAnalyticSurvBin}
\alias{summary.MetaAnalyticSurvBin}
\title{Provides a summary of the surrogacy measures for an object fitted with the 'MetaAnalyticSurvBin()' function.}
\usage{
\method{summary}{MetaAnalyticSurvBin}(object, ...)
}
\arguments{
\item{object}{An object of class 'MetaAnalyticSurvBin' fitted with the 'MetaAnalyticSurvBin()' function.}

\item{...}{...}
}
\value{
The surrogacy measures with their 95\% confidence intervals.
}
\description{
Provides a summary of the surrogacy measures for an object fitted with the 'MetaAnalyticSurvBin()' function.
}
\examples{
\dontrun{
data("colorectal")
fit_bin <- MetaAnalyticSurvBin(data = colorectal, true = surv, trueind = SURVIND,
                               surrog = responder, trt = TREAT, center = CENTER,
                               trial = TRIAL, patientid = patientid,
                               adjustment="unadjusted")
summary(fit)
}
}
