% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{Test.BNR}
\alias{Test.BNR}
\title{Test Bivariate Normal Regression Model.}
\usage{
Test.BNR(t, s, X, Z = NULL, is_zero, test = "Wald", ...)
}
\arguments{
\item{t}{Target outcome vector.}

\item{s}{Surrogate outcome vector.}

\item{X}{Target model matrix.}

\item{Z}{Surrogate model matrix.}

\item{is_zero}{Logical vector, with as many entires as columns in the target
model matrix, indicating which columns have coefficient zero under the
null.}

\item{test}{Either Score or Wald. Only Wald is available for LS.}

\item{...}{Additional arguments accepted if fitting via EM. See
\code{\link{Fit.BNEM}}.}
}
\value{
A numeric vector containing the test statistic, the degrees of
  freedom, and a p-value.
}
\description{
Performs a test of the null hypothesis that a subset of the regression
parameters for the target outcome are zero in the bivariate normal regression
model.
}
\examples{
# Generate data.
set.seed(100)
n <- 1e3
X <- cbind(1, rnorm(n))
Z <- cbind(1, rnorm(n))
data <- rBNR(X = X, Z = Z, b = c(1, 0), a = c(-1, 0), t_miss = 0.1, s_miss = 0.1)

# Test 1st coefficient.
wald_test1 <- Test.BNR(
  t = data[, 1], 
  s = data[, 2], 
  X = X, 
  Z = Z,
  is_zero = c(TRUE, FALSE),
  test = "Wald"
)

score_test1 <- Test.BNR(
  t = data[, 1], 
  s = data[, 2], 
  X = X, 
  Z = Z,
  is_zero = c(TRUE, FALSE),
  test = "Score"
)

# Test 2nd coefficient.
wald_test2 <- Test.BNR(
  t = data[, 1], 
  s = data[, 2], 
  X = X, 
  Z = Z,
  is_zero = c(FALSE, TRUE),
  test = "Wald"
)

score_test2 <- Test.BNR(
  t = data[, 1], 
  s = data[, 2], 
  X = X, 
  Z = Z,
  is_zero = c(FALSE, TRUE),
  test = "Score"
)
}
