% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_gaussvis2d.R
\name{gaussvis2d}
\alias{gaussvis2d}
\title{Sampling from a Bivariate Gaussian Distribution for Visualization}
\usage{
gaussvis2d(mean, var, n = 500)
}
\arguments{
\item{mean}{a length-\eqn{2} vector for mean parameter.}

\item{var}{a \eqn{(2\times 2)} matrix for covariance parameter.}

\item{n}{the number of points to be drawn (default: 500).}
}
\value{
an \eqn{(n\times 2)} matrix.
}
\description{
This function samples points along the contour of an ellipse represented 
by mean and variance parameters for a 2-dimensional Gaussian distribution 
to help ease manipulating visualization of the specified distribution. For example, 
you can directly use a basic \code{plot()} function directly for drawing.
}
\examples{
\donttest{
#----------------------------------------------------------------------
#                        Three Gaussians in R^2
#----------------------------------------------------------------------
# MEAN PARAMETERS
loc1 = c(-3,0)
loc2 = c(0,5)
loc3 = c(3,0)

# COVARIANCE PARAMETERS
var1 = cbind(c(4,-2),c(-2,4))
var2 = diag(c(9,1))
var3 = cbind(c(4,2),c(2,4))

# GENERATE POINTS
visA = gaussvis2d(loc1, var1)
visB = gaussvis2d(loc2, var2)
visC = gaussvis2d(loc3, var3)

# VISUALIZE
opar <- par(no.readonly=TRUE)
plot(visA[,1], visA[,2], type="l", xlim=c(-5,5), ylim=c(-2,9),
     lwd=3, col="red", main="3 Gaussian Distributions")
lines(visB[,1], visB[,2], lwd=3, col="blue")
lines(visC[,1], visC[,2], lwd=3, col="orange")
legend("top", legend=c("Type 1","Type 2","Type 3"),
       lwd=3, col=c("red","blue","orange"), horiz=TRUE)
par(opar)
}

}
\concept{other}
