% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCA.R
\name{test_data}
\alias{test_data}
\title{Generate test data}
\usage{
test_data(n, m, k, p1, p2, tau, log_file = "TCA.log", verbose = TRUE)
}
\arguments{
\item{n}{The number of observations to simulate.}

\item{m}{The number of features to simulate.}

\item{k}{The number of sources to simulate.}

\item{p1}{The number of covariates that affect the source-specific values to simulate.}

\item{p2}{The number of covariates that affect the mixture values to simulate.}

\item{tau}{The variance of the i.i.d. component of variation to add on top of the simulated mixture values.}

\item{log_file}{A path to an output log file. Note that if the file \code{log_file} already exists then logs will be appended to the end of the file. Set \code{log_file} to \code{NULL} to prevent output from being saved into a file; note that if \code{verbose == TRUE} then no output file will be generated regardless of the value of \code{log_file}.}

\item{verbose}{A logical value indicating whether to print logs.}
}
\value{
A list with the simulated data and parameters.
\item{X}{An \code{m} by \code{n} matrix of simulated data with \code{m} features for \code{n} observations.}
\item{Z}{A list with the simulated source-specific values, where the first element in the list is an \code{m} by \code{n} matrix (features by observations) corresponding to the values coming from the first source, the second element in the list is another \code{m} by \code{n} matrix (features by observations) corresponding to the values coming from the second source and so on.}
\item{W}{An \code{n} by \code{k} matrix of simulated weights - the weights of the \code{k} sources for each of the \code{n} mixtures (observations).}
\item{mus}{An \code{m} by \code{k} matrix of the mean of each of the \code{m} features for each of the \code{k} sources.}
\item{sigmas}{An \code{m} by \code{k} matrix of the standard variation of each of the \code{m} features for each of the \code{k} sources.}
\item{C1}{ An \code{n} by \code{p1} design matrix of simulated covariates that affect the hidden source-specific values.}
\item{C2}{ An \code{n} by \code{p2} design matrix of simulated covariates that affect the mixture.}
\item{gammas}{An \code{m} by \code{k*p1} matrix of the effects of the \code{p1} factors in \code{C1} on each of the \code{m} features in \code{X}, where the first \code{p1} columns are the source-specific effects of the \code{p1} factors on the first source, the following \code{p1} columns are the source-specific effects on the second source and so on.}
\item{deltas}{An \code{m} by \code{p2} matrix of the effects of the \code{p2} factors in \code{C2} on the mixture values of each of the \code{m} features in \code{X}.}
}
\description{
Generates simple test data following the TCA model.
}
\details{
See \link{tca} for details about the TCA model.
}
\examples{
data <- test_data(100, 50, 3, 2, 2, 0.01)

}
