% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{rMax2_modelsR}
\alias{rMax2_modelsR}
\title{rMax2_modelsR}
\usage{
rMax2_modelsR(rMax2Model, rMax, vMax, TClats)
}
\arguments{
\item{rMax2Model}{TC outer radius of 17.5m/s winds model ('150km'=1,'CK22'=2)}

\item{rMax}{Numeric. A vector of radius of maximum winds (km).}

\item{vMax}{Numeric. A vector of maximum wind speeds (m/s).}

\item{TClats}{Numeric. A vector of latitudes of tropical cyclone cwntre in degrees.}
}
\value{
A vector of predicted rMax175ms values (in km).
}
\description{
Numerically solves for the radius of 17.5 m/s winds (rMax175ms) using the 
Chavas and Knaff (2022) model and `uniroot`.
}
\examples{
rMax <- c(30, 36, 40)
vMax <- c(50, 55, 60)
TClats <- c(20, 25, 30)
rMax2_modelsR(2,rMax, vMax, TClats)
}
