\name{TDA-package}

\alias{TDA-package}
\alias{TDA}

\docType{package}

\title{
  Statistical Tools for Topological Data Analysis
}

\description{
  Tools for Topological Data Analysis. In particular it provides functions for the statistical analysis of persistent homology and for density clustering. For that, this package provides an R interface for the efficient algorithms of the C++ libraries \href{ https://project.inria.fr/gudhi/software/ }{GUDHI}, \href{ https://www.mrzv.org/software/dionysus/ }{Dionysus} and \href{ https://bitbucket.org/phat-code/phat/ }{PHAT}.
}

\details{
\tabular{ll}{
Package: \tab TDA\cr
Type: \tab Package\cr
Version: \tab 1.7.7\cr
Date: \tab 2021-03-27\cr
License: \tab GPL-3 \cr
}
}

\author{
  Brittany Terese Fasy, Jisu Kim, Fabrizio Lecci, Clement Maria, David L. Millman, and Vincent Rouvreau

  Maintainer: Jisu Kim <jisu.kim@inria.fr>
}

\references{
  Edelsbrunner H, Harer J (2010). "Computational topology: an introduction." American Mathematical Society.

  Fasy BT, Lecci F, Rinaldo A, Wasserman L, Balakrishnan S, Singh A (2013). "Statistical Inference For Persistent Homology: Confidence Sets for Persistence Diagrams", (arXiv:1303.7117). To appear, Annals of Statistics.

  Chazal F, Fasy BT, Lecci F, Michel B, Rinaldo A, Wasserman L (2014). "Robust Topological Inference: Distance-To-a-Measure and Kernel Distance." Technical Report.	

  Chazal F, Fasy BT, Lecci F, Rinaldo A, Wasserman L (2014). "Stochastic Convergence of Persistence Landscapes and Silhouettes." Proceedings of the 30th Symposium of Computational Geometry (SoCG). (arXiv:1312.0308)

  Chazal F, Fasy BT, Lecci F, Michel B, Rinaldo A, Wasserman L (2014). "Subsampling Methods for Persistent Homology." (arXiv:1406.1901)

  Maria C (2014). "GUDHI, Simplicial Complexes and Persistent Homology Packages." \url{ https://project.inria.fr/gudhi/software/ }.

  Morozov D (2007). "Dionysus, a C++ library for computing persistent homology." \url{ https://www.mrzv.org/software/dionysus/ }.

  Bauer U, Kerber M, Reininghaus J (2012). "PHAT, a software library for persistent homology". \url{ https://bitbucket.org/phat-code/phat/ }.
}

\keyword{package}
