% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_diagram}
\alias{plot_diagram}
\title{Plot persistence diagrams}
\usage{
plot_diagram(
  D,
  title = NULL,
  max_radius = NULL,
  legend = TRUE,
  thresholds = NULL
)
}
\arguments{
\item{D}{a persistence diagram, either outputted from either a persistent homology homology calculation like \code{\link[TDA]{ripsDiag}}/\code{\link[TDAstats]{calculate_homology}}/\code{\link{PyH}} or from \code{\link{diagram_to_df}}, with
maximum dimension at most 12.}

\item{title}{the character string plot title, default NULL.}

\item{max_radius}{the x and y limits of the plot are defined as `c(0,max_radius)`, and the default value of `max_radius` is the maximum death value in `D`.}

\item{legend}{a logical indicating whether to include a legend of feature dimensions, default TRUE.}

\item{thresholds}{either a numeric vector with one persistence threshold for each dimension in `D` or the output of a \code{\link{bootstrap_persistence_thresholds}} function call, default NULL.}
}
\description{
Plots a persistence diagram outputted from either a persistent homology calculation or from diagram_to_df, with
maximum homological dimension no more than 12 (otherwise the legend doesn't fit in the plot).
Each homological dimension has its own color (the rcartocolor color-blind safe color palette) and point type, 
and the main plot title can be altered via the `title` parameter. Each feature is plotted with
a black point at its center in order to distinguish between overlapping features and easily compare
features to their persistence thresholds.
}
\details{
The `thresholds` parameter, if not NULL, can either be a user-defined numeric vector, with
one entry (persistence threshold) for each dimension in `D`, or the output of
\code{\link{bootstrap_persistence_thresholds}}. Points whose persistence are greater than or equal to their dimension's
threshold will be plotted in their dimension's color, and in gray otherwise.
}
\examples{

if(require("TDA") & require("TDAstats"))
{
  # create a sample diagram from the unit circle
  df <- TDA::circleUnif(n = 50)
  diag <- TDAstats::calculate_homology(df,threshold = 2)

  # plot without title
  plot_diagram(diag)

  # plot with title
  plot_diagram(diag,title = "Example diagram")

  # determine persistence thresholds
  thresholds <- bootstrap_persistence_thresholds(X = df,maxdim = 1,
  thresh = 2,num_samples = 3,
  num_workers = 2)

  # plot with bootstrap persistence thresholds
  plot_diagram(diag,title = "Example diagram with thresholds",thresholds = thresholds)

  #' # plot with personalized persistence thresholds
  plot_diagram(diag,title = "Example diagram with personalized thresholds",thresholds = c(0.5,1))
}
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
