% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T_test_TFM.R
\name{T_test_TFM}
\alias{T_test_TFM}
\alias{ttestTFM}
\title{T-test for Truncated Factor Model}
\usage{
ttestTFM(X, p, alpha = 0.05)
}
\arguments{
\item{X}{A matrix or data frame of simulated or observed data from a truncated factor model.}

\item{p}{The number of variables (columns) in the dataset.}

\item{alpha}{The significance level for the t-test.}
}
\value{
A list containing:
\item{FDR}{The False Discovery Rate calculated from the rejected hypotheses.}
\item{Power}{The power of the test, representing the proportion of true positives among the non-zero hypotheses.}
\item{pValues}{A numeric vector of p-values obtained from the t-tests for each variable.}
\item{RejectedHypotheses}{A logical vector indicating which hypotheses were rejected based on the specified significance level.}
}
\description{
This function performs a simple t-test for each variable in the dataset of a truncated factor model and calculates the False Discovery Rate (FDR) and power.
}
\examples{
library(MASS)
library(mvtnorm)  # Add this line to load the mvtnorm package
set.seed(100)
p <- 400
n <- 120
K <- 5
B <- matrix(rnorm(p * K), nrow = p, ncol = K)
mu <- c(rep(1, 100), rep(0, p - 100))
FX <- MASS::mvrnorm(n, rep(0, K), diag(K))
U <- mvtnorm::rmvt(n, df = 3, sigma = diag(p))  # Use mvtnorm::rmvt
X <- rep(1, n) \%*\% t(mu) + FX \%*\% t(B) + U

# Now we can call the function with the simulated data
results <- ttestTFM(X, p, alpha = 0.05)
print(results)
}
