% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chMDB.R, R/fileMDB.R, R/generics.R,
%   R/memoMDB.R, R/metaMDB.R
\name{as_fileMDB.chMDB}
\alias{as_fileMDB.chMDB}
\alias{as_fileMDB.fileMDB}
\alias{as_fileMDB}
\alias{as_fileMDB.memoMDB}
\alias{as_fileMDB.metaMDB}
\title{Write an MDB object}
\usage{
\method{as_fileMDB}{chMDB}(
  x,
  path,
  readParameters = DEFAULT_READ_PARAMS,
  htmlModel = TRUE,
  by = 10^5,
  ...
)

\method{as_fileMDB}{fileMDB}(
  x,
  path,
  readParameters = DEFAULT_READ_PARAMS,
  htmlModel = TRUE,
  ...
)

as_fileMDB(
  x,
  path,
  readParameters = DEFAULT_READ_PARAMS,
  htmlModel = TRUE,
  ...
)

\method{as_fileMDB}{memoMDB}(
  x,
  path,
  readParameters = DEFAULT_READ_PARAMS,
  htmlModel = TRUE,
  ...
)

\method{as_fileMDB}{metaMDB}(
  x,
  path,
  readParameters = DEFAULT_READ_PARAMS,
  htmlModel = TRUE,
  ...
)
}
\arguments{
\item{x}{an MDB object}

\item{path}{the path where the MDB should be written}

\item{readParameters}{a list with 2 elements:
\itemize{
\item \strong{delim}: a single character used to separate fields within a record
(default: '\\t')
\item \strong{quoted_na}: a single logical indicating if missing values inside quotes
should bbe treated as missing values or strings
(FALSE: the default \strong{different} from \link[readr:read_delim]{readr::read_delim})
}}

\item{htmlModel}{a logical. If TRUE (default) the model is also plotted in
an html file.}

\item{by}{the size of the batch: number of records to write
together (default: 10^5)}

\item{...}{method specific parameters}
}
\value{
A \link{fileMDB} object.
}
\description{
Write an MDB object
}
