% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script_TL.pretreatment.R
\name{script_TL.pretreatment}
\alias{script_TL.pretreatment}
\title{Script for data pretreatment}
\usage{
script_TL.pretreatment(file.name, relative.error = 0.05,
  remove.discs = NULL, file.parameters = list(file.extension = ".binx",
  folder.in = "./", folder.out = "./"), aligning.parameters = list(peak.Tmin =
  NULL, peak.Tmax = NULL, no.testdose = FALSE),
  plotting.parameters = list(plot.Tmin = 0, plot.Tmax = NA, no.plot = FALSE))
}
\arguments{
\item{file.name}{\link{character} (\bold{required}): Name of the file containing the luminescence data.}

\item{relative.error}{\link{numeric} (with default): Relative error of the TL signals.}

\item{remove.discs}{\link{numeric}  (with default): list containing the position of the aliquots to remove.}

\item{file.parameters}{\link{list} (with default): list containing the file parameters. See details.}

\item{aligning.parameters}{\link{list} (with default): list containing the aligning parameters. See details.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\value{
This function return a \code{\linkS4class{TLum.Analysis}} where the preheat were removed, the background substract and the peaks aligned.
 Its  save the result as a .binx file il the specified folder.
 And, its plots the results from the differents functions called using:
 \link{plot_extract.TL},
 \link{plot_remove.preheat},
 \link{plot_substract.background} and
 \link{plot_align.peaks}. \cr
}
\description{
This script call a series of data pretreatment functions for TL dating.
It only requires the name of the files with the TL curves and the relative error on the measurement.
}
\details{
\bold{Aligning parameters} \cr
 The aligning parameters are:  \cr
 \describe{
 \item{\code{peak.Tmin}}{
   \link{numeric}: Lower boundary for looking at the peak maximum position.}
 \item{\code{peak.Tmax}}{
   \link{numeric}: Upper boundary for looking at the peak maximum position.}
 \item{\code{no.testdose}}{
   \link{logical}: If \code{TRUE}, the function will use the Lx curves rather the Tx curves as reference for the peak maximum position.}
 }

\bold{Plotting parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{plot.Tmin}}{
   \link{numeric}: Lower temperature plotted.}
 \item{\code{plot.Tmax}}{
   \link{numeric}: Higher temperature plotted.}
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
See also \link{plot_TL.MAAD}. \cr

\bold{File parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{file.extension}}{
   \link{character} (with default): extension of the file containing the luminescence data (.bin or .binx)}
 \item{\code{folder.in}}{
   \link{character} (with default): Folder containing the file with the luminescene data.}
 \item{\code{folder.out}}{
   \link{character} (with default): Folder containing the file with the new luminescene data.}
}
see also \link{mod_update.dType}.
}
\author{
David Strebler, University of Cologne (Germany), \cr David Strebler
}
\seealso{
\link{read_BIN2R},
 \link{Risoe.BINfileData2TLum.BIN.File},
 \link{mod_extract.TL},
 \link{mod_update.dType},
 \link{mod_remove.aliquot},
 \link{mod_remove.preheat},
 \link{mod_substract.background},
 \link{mod_align.peaks},
 \link{write_R2BIN}.
}

