% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMTI.R, R/zzz.R
\docType{package}
\name{TMTI}
\alias{TMTI}
\title{Computes the TMTI test for a joint hypothesis given input p-values.}
\usage{
TMTI(
  pvals,
  n = Inf,
  tau = NULL,
  K = NULL,
  gamma = NULL,
  B = 1000,
  m_max = 100,
  is.sorted = FALSE,
  ...
)
}
\arguments{
\item{pvals}{A vector of pvalues.}

\item{n}{A positive number (or Inf) indicating which type of local minimum
to consider. Defaults to Inf, corresponding to the global minimum.}

\item{tau}{Number between 0 and 1 or NULL, describing the truncation level.}

\item{K}{Integer between >1 and m describing the truncation index.}

\item{gamma}{Function; function to be used as the gamma approximation. If NULL, then
the gamma function will be bootstrapped assuming independence. Defaults
to NULL.}

\item{B}{Numeric; number of bootstrap replicates to be used when estimating
the gamma function. If a gamma is supplied, this argument is ignored.
Defaults to 1e3.}

\item{m_max}{Integer; the highest number of test for which the analytical
computation of the TMTI CDF is used. When m is above m_max it will be
bootstrapped or user supplied instead.}

\item{is.sorted}{Logical, indicating whether the supplied p-values are already
is.sorted. Defaults to FALSE.}

\item{...}{Additional parameters.}
}
\value{
A p-value from the TMTI test
}
\description{
A package to compute TMTI tests, perform closed testing
procedures with quadratic shortcuts and to generate confidence sets for the
number of false hypotheses among m tested hypotheses.
}
\examples{
## Simulate some p-values
## The first 10 are from false hypotheses, the next 10 are from true
pvals = c(
  rbeta(10, 1, 20), ## Mean value of .05
  runif(10)
)
TMTI(pvals)
}
\author{
Phillip B. Mogensen <pbm@math.ku.dk>
}
