% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerTOSTtwo.raw.R
\name{powerTOSTtwo.raw}
\alias{powerTOSTtwo.raw}
\title{Power analysis for TOST for independent t-test (raw scores)}
\usage{
powerTOSTtwo.raw(alpha, statistical_power, low_eqbound, high_eqbound, sdpooled)
}
\arguments{
\item{alpha}{alpha used for the test (e.g., 0.05)}

\item{statistical_power}{desired power (e.g., 0.8)}

\item{low_eqbound}{lower equivalence bounds (e.g., -0.5) expressed in raw scale units (e.g., scalepoints)}

\item{high_eqbound}{upper equivalence bounds (e.g., 0.5) expressed in raw scale units (e.g., scalepoints)}

\item{sdpooled}{specify the pooled standard deviation}
}
\value{
Returns a string summarizing the power analysis, and a numeric variable for the number of observations needed in each group
}
\description{
Power analysis for TOST for independent t-test (raw scores)
}
\section{References}{

Chow, S.-C., Wang, H., & Shao, J. (2007). Sample Size Calculations in Clinical Research, Second Edition - CRC Press Book. Formula 3.2.4 with k = 1
}
\examples{
## Sample size for alpha = 0.05, 80\% power, equivalence bounds of -200 and 200 in raw
## units, assuming pooled standard deviation of 350, and assuming true effect = 0
powerTOSTtwo.raw(alpha=0.05,statistical_power=0.8,low_eqbound=-200,high_eqbound=200,sdpooled=350)
}

