% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatostone.h.R
\name{dataTOSTone}
\alias{dataTOSTone}
\title{TOST One Sample T-Test}
\usage{
dataTOSTone(data, vars, mu = 0, low_eqbound = -0.5, high_eqbound = 0.5,
  eqbound_type = "d", alpha = 0.05, desc = FALSE, plots = FALSE,
  low_eqbound_d = -999999999, high_eqbound_d = -999999999)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming variables of interest in \code{data}}

\item{mu}{a number (default: 0) to compare against}

\item{low_eqbound}{a number (default: -0.5) the lower equivalence bounds}

\item{high_eqbound}{a number (default: 0.5) the upper equivalence bounds}

\item{eqbound_type}{\code{'d'} (default) or \code{'raw'}; whether the
bounds are specified in Cohen's d or raw units respectively}

\item{alpha}{alpha level (default = 0.05)}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide plots}

\item{low_eqbound_d}{deprecated}

\item{high_eqbound_d}{deprecated}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$tost} \tab \tab \tab \tab \tab a table \cr
  \code{results$eqb} \tab \tab \tab \tab \tab a table \cr
  \code{results$desc} \tab \tab \tab \tab \tab a table \cr
  \code{results$plots} \tab \tab \tab \tab \tab an array of images \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$tost$asDF}

\code{as.data.frame(results$tost)}
}
\description{
TOST One Sample T-Test
}
\examples{
library("TOSTER")

dataTOSTone(data=iris, vars="Sepal.Width", mu=3, low_eqbound=-0.3, high_eqbound=0.3,
            alpha=0.05, desc=TRUE, plots=TRUE)

TOSTone(m=3.05733, mu=3, sd=0.4358663, n=150, low_eqbound_d=-0.3, high_eqbound_d=0.3, alpha=0.05)

}
