% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subspace.R
\name{subspace}
\alias{subspace}
\title{The distance between two subspaces.}
\usage{
subspace(A, B)
}
\arguments{
\item{A}{A \eqn{p}-by-\eqn{u} full column rank matrix.}

\item{B}{A \eqn{p}-by-\eqn{u} full column rank matrix.}
}
\value{
Returns a distance metric that is between 0 and 1
}
\description{
This function calculates the distance between the two subspaces with equal dimensions span\eqn{(A)} and span\eqn{(B)}, where \eqn{A \in R^{p\times u}} and \eqn{B \in R^{p\times u}} are the basis matrices of two subspaces. The distance is defined as
\deqn{\|P_{A} - P_{B}\|_F/\sqrt{2d},}
where \eqn{P} is the projection matrix onto the given subspace with the standard inner product, and \eqn{d} is the common dimension.
}
