% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSMining.R
\name{Func.motif.multivariate}
\alias{Func.motif.multivariate}
\title{A function to implment the multivariate motif discovery}
\usage{
Func.motif.multivariate(motif.list, window.sizes, alpha)
}
\arguments{
\item{motif.list}{is a list of lists, each contains the univariate motifs discovered in a univariate time series. The component of motif.list is the results of Func.motif()$Indices, which store the starting position of subsequences of each univariate motif}

\item{window.sizes}{is a vector containing the length of motifs in each univariate time series. It should have the same order as components in motif.list.}

\item{alpha}{is a numeric ranging from 0 to 1. It specifies the minimum correlation between two univariate motifs before considered as a multivariate motifs}
}
\value{
The function returns a list containing two elements. The first element is Motif, which is a list containing the univarate motif IDs for different multivariate motifs. e.g., if there are two univariate time series and each has 3 motifs, then univariate ID is from 1 to 6. The second element is Info, which is a list storing the information of univariate motifs for different multivariate motifs
}
\description{
This function implements the multivariate motif discovery method proposed in A. Vahdatpour, N. Amini, M. Sarrafzadeh. Towards unsupervised activity discovery using multi-dimensional motif detection in time series. IJCAI 2009 21st International Joint Conference on Artificial Intelligence.
}
\examples{
data(test)
#Perform univariate motif discovery for each dimension in the example data
res.1 <- Func.motif(ts = test$TS1, global.norm = TRUE, local.norm = FALSE,
window.size = 10, overlap = 0, w = 5, a = 3, mask.size = 3, eps = .01)
res.2 <- Func.motif(ts = test$TS2, global.norm = TRUE, local.norm = FALSE,
window.size = 20, overlap = 0, w = 5, a = 3, mask.size = 3, eps = .01)
#Perform multivaraite motif discovery
res.multi <- Func.motif.multivariate(motif.list = list(res.1$Indices, res.2$Indices),
window.sizes = c(10,20), alpha = .8)
}

