% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.TSVC.R
\name{summary.TSVC}
\alias{summary.TSVC}
\alias{print.summary.TSVC}
\title{Summary of Tree-Structured Varying Coefficient Models}
\usage{
\method{summary}{TSVC}(object, ...)

\method{print}{summary.TSVC}(x, ...)
}
\arguments{
\item{object}{object of class \code{\link[TSVC]{TSVC}}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{object of class \code{\link[TSVC]{summary.TSVC}}.}
}
\value{
object of class \code{"summary.TSVC"}. An object of class \code{"summary.TSVC"} is a list containing the 
following components: 

\item{stats}{overview of detected varying coefficients, responsible effect modifiers and executed splits.}
\item{nosplits}{total number of executed splits during the fitting process.}
}
\description{
Summary for an object of class \code{TSVC}, with an overview of all executed splits during the fitting process.
}
\examples{
# Swiss Labour Market 
library(AER)
data("SwissLabor")

# recode factors
sl <- SwissLabor
sl$participation <- as.numeric(sl$participation)-1
sl$foreign       <- as.numeric(sl$foreign)-1

\dontshow{
fit0 <- TSVC(participation~foreign+oldkids, data=sl, family=binomial(link="logit"), 
             nperm=50, trace=TRUE)
summary(fit0)
}
\donttest{
fit1 <- TSVC(participation~income+age, data=sl, family=binomial(link="logit"), 
             nperm=300, trace=TRUE)
summary(fit1)
}


}
\references{
Berger, M., G. Tutz and M. Schmid (2018). Tree-Structured Modelling of Varying Coefficients. Statistics and Computing. Under review.
}
\seealso{
\code{\link[TSVC]{TSVC}}, \code{\link[TSVC]{plot.TSVC}}, \code{\link[TSVC]{predict.TSVC}}
}
\author{
Moritz Berger <Moritz.Berger@imbie.uni-bonn.de> \cr \url{http://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
