% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{denorm_min_max}
\alias{denorm_min_max}
\title{Min-Max denormalisation}
\usage{
denorm_min_max(x, min, max)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{min}{the minimum value}

\item{max}{the maximal value}
}
\value{
the numeric vector of denormalised values
}
\description{
The \code{denorm_min_max} denormalises time series by min-max method.
}
\examples{
# Normalise values and save normalisation parameters:
norm_res <- norm_min_max_list(rnorm(50, 5, 2))
# Denormalise new data with previous computed parameters:
denorm_min_max(rnorm(50, 4, 2), min = norm_res$min, max = norm_res$max)

}
\references{
Laurinec P, Lucká M (2018)
Clustering-based forecasting method for individual consumers electricity load using time series representations.
Open Comput Sci, 8(1):38–50, DOI: 10.1515/comp-2018-0006
}
\seealso{
\code{\link[TSrepr]{norm_min_max}, \link[TSrepr]{norm_min_max_list}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
