% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_based_repr.R
\name{repr_gam}
\alias{repr_gam}
\title{GAM regression coefficients as representation}
\usage{
repr_gam(x, freq = NULL, xreg = NULL)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{freq}{the frequency of the time series. Can be vector of two frequencies (seasonalities) or just an integer of one frequency.}

\item{xreg}{the numeric vector or the data.frame with additional exogenous regressors}
}
\value{
the numeric vector of GAM regression coefficients
}
\description{
The \code{repr_gam} computes seasonal GAM regression coefficients. Additional exogenous variables can be also added.
}
\details{
This model-based representation method extracts regression coefficients from a GAM (Generalized Additive Model).
The extraction of seasonal regression coefficients is automatic.
The maximum number of seasonalities is 2 so it is possible to compute representation for double-seasonal time series.
The first set seasonality (frequency) is main, so for example if we have hourly time series (\code{freq = c(24, 24*7)}),
the number of extracted daily seasonal coefficients is 24 and the number of
weekly seasonal coefficients is 7, because the length of second seasonality representation is always freq_1 / freq_2.
The smooth function for seasonal variables is set to cubic regression spline.
There is also possibility to add another independent variables (\code{xreg}).
}
\examples{
repr_gam(rnorm(96), freq = 24)

}
\references{
Laurinec P, Lucka M (2016)
Comparison of representations of time series for clustering smart meter data.
In: Lecture Notes in Engineering and Computer Science: Proceedings of The World Congress on Engineering and Computer Science 2016, pp 458-463

Laurinec P, Loderer M, Vrablecova P, Lucka M, Rozinajova V, Ezzeddine AB (2016)
Adaptive time series forecasting of energy consumption using optimized cluster analysis.
In: Data Mining Workshops (ICDMW), 2016 IEEE 16th International Conference on, IEEE, pp 398-405

Laurinec P, Lucká M (2018)
Clustering-based forecasting method for individual consumers electricity load using time series representations.
Open Comput Sci, 8(1):38–50, DOI: 10.1515/comp-2018-0006
}
\seealso{
\code{\link[TSrepr]{repr_lm}, \link[TSrepr]{repr_exp}, \link[mgcv]{gam}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
