% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis_testing.R
\name{compute_V_pT}
\alias{compute_V_pT}
\title{Compute \eqn{V_{pT}} Statistic for Covariance Time-Variation Hypothesis Testing}
\usage{
compute_V_pT(local_factors, residuals, h, iT, ip, kernel_func)
}
\arguments{
\item{local_factors}{A list where each element is a numeric matrix representing the
local factor scores for a specific time period. Each matrix should have \eqn{T} rows
(time periods) and \eqn{m} columns (factors).}

\item{residuals}{A numeric matrix of residuals with \eqn{T} rows (time periods) and \eqn{p} columns (assets).}

\item{h}{A numeric value indicating the bandwidth parameter for the kernel function.}

\item{iT}{An integer specifying the number of time periods.}

\item{ip}{An integer specifying the number of assets.}

\item{kernel_func}{A function representing the kernel used for weighting. Typically, an
Epanechnikov kernel or another boundary kernel function.}
}
\value{
A numeric scalar \eqn{V_{pT}} representing the computed statistic based on
kernel-weighted factor interactions and residual correlations.
}
\description{
This function calculates the \eqn{V_{pT}} statistic, which is part of the hypothesis
testing procedure to determine whether the covariance matrix of asset returns is time-varying.
It incorporates kernel-weighted factor interactions and residual correlations.
}
\details{
The function performs the following steps:
\enumerate{
  \item Iterates over each pair of time periods \eqn{(s, r)} where \eqn{s < r}.
  \item Computes the two-fold convolution kernel value \eqn{\bar{K}_{sr}} using the
  \code{two_fold_convolution_kernel} function.
  \item Calculates the squared dot product of local factors weighted by the factor covariance
  matrix.
  \item Computes the squared dot product of residuals between time periods \eqn{s} and \eqn{r}.
  \item Aggregates these values across all relevant time period pairs and scales by
  \eqn{\frac{2}{T^2 × p × h}} to obtain \eqn{V_{pT}}.
}
}
\keyword{internal}
