% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tariff.r
\name{tariff}
\alias{tariff}
\title{Replicate Tariff methods}
\usage{
tariff(causes.train, symps.train, symps.test, causes.table = NULL,
  use.rank = TRUE, nboot.rank = 1, use.sig = TRUE, nboot.sig = 500,
  use.top = FALSE, ntop = 40, ...)
}
\arguments{
\item{causes.train}{character vector of causes, or the column name of cause in the training data}

\item{symps.train}{N.train by S matrix}

\item{symps.test}{N.test by S matrix}

\item{causes.table}{list of causes in the data}

\item{use.rank}{logical indicator for whether using ranks instead of scores}

\item{nboot.rank}{number of re-sampling for baseline rank comparison}

\item{use.sig}{logical indicator for whether using significant Tariff only}

\item{nboot.sig}{number of re-sampling for testing significance.}

\item{use.top}{logical indicator for whether the tariff matrix should be cleaned to have only top symptoms}

\item{ntop}{number of top tariff kept for each cause}

\item{...}{not used}
}
\value{
\item{score}{matrix of score for each cause within each death}
\item{causes.train}{vector of most likely causes in training data} 
\item{causes.test}{vector of most likely causes in testing data} 
\item{csmf}{vector of CSMF}
\item{causes.table}{cause list used for output, i.e., list of existing causes in the training data}
\item{use.rank}{logical indicator for whether using ranks instead of scores}
}
\description{
This function implements Tariff method.
}
\examples{
\donttest{
data("RandomVA3")
test <- RandomVA3[1:200, ]
train <- RandomVA3[201:400, ]
allcauses <- unique(train$cause)
fit <- tariff(causes.train = "cause", symps.train = train, 
				symps.test = test, causes.table = allcauses)
correct <- which(fit$causes.test[,2] == test$cause)
accuracy <- length(correct) / dim(test)[1]
}
}
\references{
James, S. L., Flaxman, A. D., Murray, C. J., & Population Health Metrics Research Consortium. (2011). \emph{Performance of the Tariff Method: validation of a simple additive algorithm for analysis of verbal autopsies.} \emph{Population Health Metrics, 9(1), 1-16.}

Serina, P., Riley, I., Stewart, A., James, S. L., Flaxman, A. D., Lozano, R., ... & Ahuja, R. (2015). \emph{Improving performance of the Tariff Method for assigning causes of death to verbal autopsies.} \emph{BMC medicine, 13(1), 1.}

Tyler H. McCormick, Zehang R. Li, Clara Calvert, Amelia C.
Crampin, Kathleen Kahn and Samuel J. Clark(2016) \emph{Probabilistic
cause-of-death assignment using verbal autopsies},
\url{http://arxiv.org/abs/1411.3042} \emph{To appear, Journal of the American Statistical Association}
}
\author{
Zehang Li, Tyler McCormick, Sam Clark

Maintainer: Zehang Li <lizehang@uw.edu>
}
\keyword{Tariff}
